package com.clx.performance.sqlProvider;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.PageIntegralStatisticsParam;
import com.clx.performance.vo.pc.IntegralStatisticsVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class IntegralStatisticsSqlProvider {

    public String pageByParam(@Param("page") Page<IntegralStatisticsVO> page, @Param("param") PageIntegralStatisticsParam param) {
        return new SQL(){{

            SELECT(" id, truck_no as truckNo, date_format(statistics_date, '%Y-%m-%d %H:%i:%s') as statisticsDate, " +
                    " integral_base as integralBase, integral, rank, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime ");

            FROM("integral_statistics");

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            ORDER_BY("truck_no asc, statistics_date desc, integral desc ");
        }}.toString();
    }

}
