package com.clx.performance.service.impl;

import com.clx.performance.dao.IntegralRecordDao;
import com.clx.performance.dao.IntegralStatisticsDao;
import com.clx.performance.dao.IntegralTruckDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.IntegralRecord;
import com.clx.performance.model.IntegralStatistics;
import com.clx.performance.model.IntegralTruck;
import com.clx.performance.param.pc.IntegralRecordAddParam;
import com.clx.performance.service.IntegralMqService;
import com.clx.performance.service.IntegralRecordService;
import com.clx.performance.utils.LocalDateTimeUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class IntegralRecordServiceImpl implements IntegralRecordService {

    @Autowired
    private IntegralRecordDao integralRecordDao;

    @Autowired
    private IntegralTruckDao integralTruckDao;

    @Autowired
    private IntegralStatisticsDao integralStatisticsDao;

    @Autowired
    private IntegralMqService integralMqService;

    @Override
    public void addRecord(IntegralRecordAddParam param) {
        String statisticsDate = LocalDateTimeUtils.getWeekStart();

        IntegralTruck truck = integralTruckDao.getByTruckNo(param.getTruckNo()).orElseThrow(PerformanceResultEnum.INTEGRAL_TRUCK_NO_EXIST);

        // 查找最新统计
        IntegralStatistics statistics = integralStatisticsDao.selectByTruckNoAndStatisticsDate(param.getTruckNo(), statisticsDate).orElseThrow(PerformanceResultEnum.INTEGRAL_TRUCK_NO_EXIST);

        // 更新积分
        statistics.setIntegral(statistics.getIntegral()+param.getIntegral());
        integralStatisticsDao.updateIntegral(statistics);

        truck.setIntegral(statistics.getIntegral());
        integralTruckDao.updateIntegral(truck);

        // 新增积分记录
        IntegralRecord record = save(statistics.getId(), statistics.getStatisticsDate(), statistics.getTruckNo(), IntegralRecord.type.SYSTEM.getValue(), param.getIntegral(), param.getRemark());

        // 发送mq (新增积分记录)
        integralMqService.integralRecordAdd(record.getStatisticsId(), record.getTruckNo(), record.getType(), record.getIntegral(), record.getRemark());

    }

    @Override
    public IntegralRecord save(Integer statisticsId, String statisticsDate, String truckNo, Integer type, Integer integral, String remark){
        IntegralRecord record = new IntegralRecord();
        record.setStatisticsId(statisticsId);
        record.setStatisticsDate(statisticsDate);
        record.setTruckNo(truckNo);
        record.setType(type);
        record.setIntegral(integral);
        record.setRemark(remark);

        // 新增记录
        integralRecordDao.saveEntity(record);

        return record;
    }

}
