package com.clx.performance.service.impl;

import com.alibaba.fastjson.JSON;
import com.clx.performance.constant.RabbitKeyIntegralConstants;
import com.clx.performance.param.mq.IntegralNextWeekTruckInitMqParam;
import com.clx.performance.param.mq.IntegralOrderChildFinishMqParam;
import com.clx.performance.param.mq.IntegralTruckProtectionCancelMqParam;
import com.clx.performance.param.mq.IntegralWeekTruckStatisticsMqParam;
import com.clx.performance.service.IntegralMqService;
import com.clx.performance.utils.MqWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author: aiqingguo
 * @Description: 司机积分 mq
 * @Date: 2023-10-10 13:21:07
 * @Version: 1.0
 */

@Slf4j
@Service
public class IntegralMqServiceImpl implements IntegralMqService {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private IntegralMqHandlerServiceImpl integralMqHandlerService;

    /**
     * 新增车辆 (performance)
     */
    @Override
    public void truckAdd(Integer statisticsId, String truckNo){

//        IntegralTuckAddMQ mq = new IntegralTuckAddMQ();
//        mq.setStatisticsId(statisticsId);
//        mq.setTruckNo(truckNo);
//        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(mq)).getBytes()).build();
//        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_TRUCK_ADD_ROUTING_KEY, message);

        // 实时积分统计
        integralMqHandlerService.integralRealTimeStatistics(statisticsId);

    }

    /**
     * 新增积分记录 (performance)
     */
    @Override
    public void integralRecordAdd(Integer statisticsId, String truckNo, Integer type, Integer integral, String remark){

//        IntegralRecordAddMQ mq = new IntegralRecordAddMQ();
//        mq.setStatisticsId(statisticsId);
//        mq.setTruckNo(truckNo);
//        mq.setType(type);
//        mq.setIntegral(integral);
//        mq.setRemark(remark);
//        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(mq)).getBytes()).build();
//        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_RECORD_ADD_ROUTING_KEY, message);

        // 实时积分统计
        integralMqHandlerService.integralRealTimeStatistics(statisticsId);
    }

    /**
     * 下周车辆初始化 (job)
     */
    @Override
    public void nextWeekTruckInit(String statisticsDate){

        IntegralNextWeekTruckInitMqParam mq = new IntegralNextWeekTruckInitMqParam();
        mq.setStatisticsDate(statisticsDate);

        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(mq)).getBytes()).build();
        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_NEXT_WEEK_TRUCK_INIT_ROUTING_KEY, message);
    }

    /**
     * 车辆周统计 (结算上周积分) (job)
     */
    @Override
    public void weekTruckStatistics(String statisticsDate){

        IntegralWeekTruckStatisticsMqParam mq = new IntegralWeekTruckStatisticsMqParam();
        mq.setStatisticsDate(statisticsDate);

        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(mq)).getBytes()).build();
        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_WEEK_TRUCK_STATISTICS_ROUTING_KEY, message);
    }
    /**
     * 车辆周统计 (结算上周积分) (job)
     */
    @Override
    public void weekTruckStatistics(String statisticsDate, String truckNo){

        IntegralWeekTruckStatisticsMqParam mq = new IntegralWeekTruckStatisticsMqParam();
        mq.setStatisticsDate(statisticsDate);
        mq.setTruckNo(truckNo);

        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(mq)).getBytes()).build();
        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_WEEK_TRUCK_STATISTICS_ROUTING_KEY, message);
    }

    /**
     * 新车保护取消 (job)
     */
    @Override
    public void truckProtectionCancel(String statisticsDate, String truckNo){

        IntegralTruckProtectionCancelMqParam mq = new IntegralTruckProtectionCancelMqParam();
        mq.setStatisticsDate(statisticsDate);
        mq.setTruckNo(truckNo);

        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(mq)).getBytes()).build();
        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_TRUCK_PROTECTION_CANCEL_ROUTING_KEY, message);
    }

    /**
     * 运单结束 (performance)
     */
    @Override
    public void orderChildFinish(String childNo){

        IntegralOrderChildFinishMqParam mq = new IntegralOrderChildFinishMqParam();
        mq.setChildNo(childNo);

        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(mq)).getBytes()).build();
        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_ORDER_CHILD_FINISH_ROUTING_KEY, message);

    }

}
