package com.clx.performance.service;

import com.clx.performance.model.IntegralTruck;
import com.clx.performance.utils.LocalDateTimeUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class IntegralJobHandlerService {


    @Autowired
    private IntegralMqService integralMqService;


    /**
     * 下周车辆初始化
     */
    public void nextWeekTruckInit(){

        // 发送mq (下周车辆初始化)
        integralMqService.nextWeekTruckInit(LocalDateTimeUtils.getWeekStart());

    }

    /**
     * 车辆周统计 (结算上周积分)
     */
    public void weekTruckStatistics(){

        // 发送mq (下周车辆初始化)
        integralMqService.weekTruckStatistics(LocalDateTimeUtils.getWeekStart());
    }
    public void weekTruckStatistics(IntegralTruck truck){

        // 发送mq (下周车辆初始化)
        integralMqService.weekTruckStatistics(LocalDateTimeUtils.getWeekStart(), truck.getTruckNo());
    }

    /**
     * 车辆保护取消
     */
    public void truckProtectionCancel(IntegralTruck truck){

        // 发送mq (车辆保护取消)
        integralMqService.truckProtectionCancel(LocalDateTimeUtils.getWeekStart(), truck.getTruckNo());
    }

}
