package com.clx.performance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.IntegralTruck;
import com.clx.performance.param.pc.PageIntegralTruckParam;
import com.clx.performance.sqlProvider.IntegralTruckSqlProvider;
import com.clx.performance.vo.pc.IntegralTruckVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;

/**
* @Author: aiqinguo
* @Description: 积分车辆
* @Date: 2023-10-9 11:52:22
* @Version: 1.0
*/

@Mapper
public interface IntegralTruckMapper extends BaseMapper<IntegralTruck> {

    /**
     * 查询是否存在(按车牌号)
     */
    @Select("SELECT IFNULL((SELECT 1 FROM integral_truck WHERE truck_no=#{truckNo} LIMIT 1),0)")
    int existByTruckNo(@Param("truckNo")String truckNo);

    /**
     * @see IntegralTruckSqlProvider#pageByParam(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.PageIntegralTruckParam)
     */
    @SelectProvider(type = IntegralTruckSqlProvider.class, method = "pageByParam")
    IPage<IntegralTruckVO> pageByParam(@Param("page") Page<IntegralTruckVO> page, @Param("param") PageIntegralTruckParam param);

    @Select("select id, truck_no,  rank, " +
            " id, truck_no, " +
            " driver_name, driver_mobile, " +
            " echelon, integral, rank, " +
            " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
            " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime " +
            " from integral_truck " +
            " order by integral desc, create_time desc ")
    IPage<IntegralTruckVO> pageTruckRank(@Param("page") Page<IntegralTruckVO> page);

}