package com.clx.performance.controller.pc;

import com.clx.performance.param.pc.GoodsOrderMapParam;
import com.clx.performance.service.GoodsOrderMapService;
import com.clx.performance.vo.pc.GoodsOrderSendAddressSelect;
import com.clx.performance.vo.pc.TruckCoordinateVO;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName GoodsOrderController
 * @Description
 * @Author kavin
 * @Date 2023/9/17 17:16
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping("/pc/goodsOrderMap")
@Validated
@Api(tags = "PC-货单地图")
public class GoodsOrderMapController {



    @Autowired
    GoodsOrderMapService goodsOrderMapService;

    @ApiOperation(value = "获取货源地下拉列表", notes = "<br>By:刘海泉")
    @PostMapping("/getSendAddressSelect")
    public Result<List<GoodsOrderSendAddressSelect>> getSendAddressSelect(@RequestBody @Validated GoodsOrderMapParam param) {
        return Result.ok(goodsOrderMapService.getSendAddressSelect(param));
    }

    @ApiOperation(value = "获取平台车辆信息", notes = "<br>By:刘海泉")
    @GetMapping("/getPlatformTruckCoordinate")
    public Result<List<TruckCoordinateVO>> getPlatformTruckCoordinate() {
        return Result.ok(goodsOrderMapService.getPlatformTruckCoordinate());
    }


    @ApiOperation(value = "获取货单车辆", notes = "<br>By:刘海泉")
    @GetMapping("/getOrderChildTruckByOrderNo")
    public Result<List<String>> getOrderChildTruckByOrderNo(String orderNo) {
        return Result.ok(goodsOrderMapService.getOrderChildTruckByOrderNo(orderNo));
    }




}
