package com.clx.performance.config;

import com.clx.performance.constant.RabbitKeyIntegralConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: aiqingguo
 * @Description: 司机积分 MQ
 * @Date: 2023-10-12 16:27:30
 * @Version: 1.0
 */
@Configuration
public class RabbitOrderIntegralConfig {

    @Bean
    public DirectExchange integralDefaultExchange() {
        return new DirectExchange(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE);
    }

    @Bean
    public Queue integralDefaultDelayQueue() {
        Map<String, Object> params = new HashMap<>(8);
        params.put("x-message-ttl", 15 * 60 * 1000);
        params.put("x-max-length", 5000000);
        params.put("x-dead-letter-exchange", RabbitKeyIntegralConstants.DEFAULT_EXCHANGE);
        params.put("x-dead-letter-routing-key", RabbitKeyIntegralConstants.DEFAULT_DEAD_ROUTING_KEY);
        return new Queue(RabbitKeyIntegralConstants.DEFAULT_DELAY_QUEUE, true, false, false, params);
    }
    @Bean
    public Binding integralDefaultDelayQueueBinding() {
        return BindingBuilder.bind(integralDefaultDelayQueue()).to(integralDefaultExchange()).with(RabbitKeyIntegralConstants.DEFAULT_DELAY_ROUTING_KEY);
    }

    @Bean
    public Queue integralDefaultDeadQueue() {
        return new Queue(RabbitKeyIntegralConstants.DEFAULT_DEAD_QUEUE);
    }
    @Bean
    public Binding integralDefaultDeadQueueBinding() {
        return BindingBuilder.bind(integralDefaultDeadQueue()).to(integralDefaultExchange()).with(RabbitKeyIntegralConstants.DEFAULT_DEAD_ROUTING_KEY);
    }


    /**
     * 积分车辆新增
     */
    @Bean
    public Queue integralTruckAddQueue() {
        return new Queue(RabbitKeyIntegralConstants.INTEGRAL_TRUCK_ADD_QUEUE);
    }
    @Bean
    public Binding integralTruckAddQueueBinding() {
        return BindingBuilder.bind(integralTruckAddQueue()).to(integralDefaultExchange()).with(RabbitKeyIntegralConstants.INTEGRAL_TRUCK_ADD_ROUTING_KEY);
    }

    /**
     * 积分记录新增
     */
    @Bean
    public Queue integralRecordAddQueue() {
        return new Queue(RabbitKeyIntegralConstants.INTEGRAL_RECORD_ADD_QUEUE);
    }
    @Bean
    public Binding integralRecordAddQueueBinding() {
        return BindingBuilder.bind(integralRecordAddQueue()).to(integralDefaultExchange()).with(RabbitKeyIntegralConstants.INTEGRAL_RECORD_ADD_ROUTING_KEY);
    }

    /**
     * 下周车辆初始化
     */
    @Bean
    public Queue integralNextWeekTruckInitQueue() {
        return new Queue(RabbitKeyIntegralConstants.INTEGRAL_NEXT_WEEK_TRUCK_INIT_QUEUE);
    }
    @Bean
    public Binding integralNextWeekTruckInitQueueBinding() {
        return BindingBuilder.bind(integralNextWeekTruckInitQueue()).to(integralDefaultExchange()).with(RabbitKeyIntegralConstants.INTEGRAL_NEXT_WEEK_TRUCK_INIT_ROUTING_KEY);
    }

    /**
     * 车辆周统计
     */
    @Bean
    public Queue integralWeekTruckStatisticsQueue() {
        Map<String, Object> params = new HashMap<>(8);
        params.put("x-single-active-consumer", true);
        return new Queue(RabbitKeyIntegralConstants.INTEGRAL_WEEK_TRUCK_STATISTICS_QUEUE, true, false, false, params);
    }
    @Bean
    public Binding integralWeekTruckStatisticsQueueBinding() {
        return BindingBuilder.bind(integralWeekTruckStatisticsQueue()).to(integralDefaultExchange()).with(RabbitKeyIntegralConstants.INTEGRAL_WEEK_TRUCK_STATISTICS_ROUTING_KEY);
    }

    /**
     * 新手保护取消
     */
    @Bean
    public Queue integralNewTruckProtectionCancelQueue() {
        return new Queue(RabbitKeyIntegralConstants.INTEGRAL_TRUCK_PROTECTION_CANCEL_QUEUE);
    }
    @Bean
    public Binding integralNewTruckProtectionCancelQueueBinding() {
        return BindingBuilder.bind(integralNewTruckProtectionCancelQueue()).to(integralDefaultExchange()).with(RabbitKeyIntegralConstants.INTEGRAL_TRUCK_PROTECTION_CANCEL_ROUTING_KEY);
    }

    /**
     * 运单结束
     */
    @Bean
    public Queue integralOrderChildFinishQueue() {
        Map<String, Object> params = new HashMap<>(8);
        params.put("x-single-active-consumer", true);
        return new Queue(RabbitKeyIntegralConstants.INTEGRAL_ORDER_CHILD_FINISH_QUEUE, true, false, false, params);
    }

    @Bean
    public Binding integralOrderChildFinishQueueBinding() {
        return BindingBuilder.bind(integralOrderChildFinishQueue()).to(integralDefaultExchange()).with(RabbitKeyIntegralConstants.INTEGRAL_ORDER_CHILD_FINISH_ROUTING_KEY);
    }

}
