package com.clx.performance.vo.pc;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName GoodsOrderSendAddressSelect
 * @Description
 * @Author kavin
 * @Date 2023/10/10 10:44
 * @Version 1.0
 */

@ApiModel(description = "货单地图货源地下拉选")
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class GoodsOrderSendAddressSelect {

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("发货地址ID")
    private Integer sendAddressId;

    @ApiModelProperty("发货地址简称")
    private String sendAddressShorter;

    @ApiModelProperty("发货地址经度")
    private BigDecimal sendLongitude;

    @ApiModelProperty("发货地址纬度")
    private BigDecimal sendLatitude;

    @ApiModelProperty("挂单运费")
    private List<Freight> freightList;


}
