package com.clx.performance.dao.impl.settle;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementOwnerDao;
import com.clx.performance.enums.settle.SettlementOwnerEnum;
import com.clx.performance.mapper.settle.SettlementOwnerMapper;
import com.clx.performance.model.settle.SettlementOwner;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerParam;
import com.msl.common.base.Optional;
import com.clx.performance.param.pc.owner.PageOwnerSettlementParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

/**
 * @Author: aiqinguo
 * @Description: 货主结算单
 * @Date: 2023-10-11 18:04:09
 * @Version: 1.0
 */
@Repository
public class SettlementOwnerDaoImpl extends BaseDaoImpl<SettlementOwnerMapper, SettlementOwner, Integer> implements SettlementOwnerDao {

    @Override
    public boolean updateSettlementPeriodMonth(SettlementOwner item) {
        return update(lUdWrapper()
                .eq(SettlementOwner::getId, item.getId())
                .set(SettlementOwner::getWeight, item.getWeight())
                .set(SettlementOwner::getFreight, item.getFreight())
                .set(SettlementOwner::getLossWeight, item.getLossWeight())
                .set(SettlementOwner::getLossFreight, item.getLossFreight())
                .set(SettlementOwner::getSettlementFreight, item.getSettlementFreight())
                .set(SettlementOwner::getInvoiceFreight, item.getInvoiceFreight())
                .set(SettlementOwner::getPrepayFreight, item.getPrepayFreight())
        );
    }

    @Override
    public boolean updateLock(SettlementOwner item) {
        return update(lUdWrapper()
                .eq(SettlementOwner::getId, item.getId())
                .eq(SettlementOwner::getStatus, SettlementOwnerEnum.Status.TO_BE_LOCKED.getCode())
                .set(SettlementOwner::getStatus, item.getStatus())
        );
    }

    @Override
    public List<SettlementOwner> getMergeSettlementNos(String settlementNo) {
        return super.list(lQrWrapper()
                .eq(SettlementOwner::getSettlementNo, settlementNo)
                .eq(SettlementOwner::getMergeStatus, SettlementOwnerEnum.MergeStatus.YES.getCode())
                .orderByDesc(SettlementOwner::getId));
    }

    @Override
    public boolean updateStatusBySettlementNo(String settlementNo, Integer status) {
        return update(lUdWrapper()
                .eq(SettlementOwner::getSettlementNo, settlementNo)
                .set(SettlementOwner::getStatus, status)
        );
    }

    @Override
    public boolean updateInvoiceStatusById(Integer id, Integer invoiceStatus){
        return update(lUdWrapper()
                .eq(SettlementOwner::getId, id)
                .set(SettlementOwner::getInvoiceStatus, invoiceStatus)
        );
    }
    @Override
    public boolean updatePayment(SettlementOwner settlementOwner) {
        return update(lUdWrapper()
                .eq(SettlementOwner::getSettlementNo, settlementOwner.getSettlementNo())
                .set(SettlementOwner::getStatus, settlementOwner.getStatus())
                .set(SettlementOwner::getPayee, settlementOwner.getPayee())
                .set(SettlementOwner::getPayeeBankCardNo, settlementOwner.getPayeeBankCardNo())
                .set(SettlementOwner::getPayeeBankName, settlementOwner.getPayeeBankName())
                .set(SettlementOwner::getPaymentImg, settlementOwner.getPaymentImg())
                .set(SettlementOwner::getPaymentBankCardNo, settlementOwner.getPaymentBankCardNo())
                .set(SettlementOwner::getPaymentBankName, settlementOwner.getPaymentBankName())
        );
    }

    @Override
    public IPage<SettlementOwner> pageCarrierSettlementOwner(PageCarrierSettlementOwnerParam param) {
        LambdaQueryWrapper<SettlementOwner> query = new LambdaQueryWrapper<>();
        if(Objects.nonNull(param.getOwnerUserNo())){
            query.eq(SettlementOwner :: getOwnerUserNo,param.getOwnerUserNo());
        }
        if(StringUtils.isNotBlank(param.getSettlementNo())){
            query.eq(SettlementOwner :: getSettlementNo,param.getSettlementNo());
        }
        if(StringUtils.isNotBlank(param.getStatus())){
            query.eq(SettlementOwner :: getStatus,param.getStatus());
        }
        if(StringUtils.isNotBlank(param.getOwnerUserName())){
            query.like(SettlementOwner :: getOwnerName,param.getOwnerUserName());
        }
        if(Objects.nonNull(param.getSettlementWay())){
            query.like(SettlementOwner :: getSettlementWay,param.getSettlementWay());
        }
        query.orderByDesc(SettlementOwner :: getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(),param.getPageSize()),query);

    }

    @Override
    public Optional<SettlementOwner> selectBySettlementNo(String settlementNo) {
        return Optional.of(settlementNo)
                .map(item -> lQrWrapper()
                        .eq(SettlementOwner::getSettlementNo, item)
                        .eq(SettlementOwner::getMergeStatus, SettlementOwnerEnum.MergeStatus.NO.getCode()))
                .map(super::getOne);
    }

    @Override
    public IPage<SettlementOwner> pageSettlementOwner(Long userNo,PageOwnerSettlementParam param) {
        LambdaQueryWrapper<SettlementOwner> query = new LambdaQueryWrapper<>();
        query.eq(SettlementOwner :: getOwnerUserNo,userNo);
        if(StringUtils.isNotBlank(param.getOrderNo())){
            query.eq(SettlementOwner :: getOrderNo,param.getOrderNo());
        }
        if(StringUtils.isNotBlank(param.getSettlementNo())){
            query.eq(SettlementOwner :: getSettlementNo,param.getSettlementNo());
        }
        if(Objects.nonNull(param.getStatus())){
            query.eq(SettlementOwner :: getStatus,param.getStatus());
        }
        query.orderByDesc(SettlementOwner :: getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(),param.getPageSize()),query);
    }

    @Override
    public Optional<SettlementOwner> selectUnlockOfSettlementPeriodMonth(String orderNo, LocalDateTime settlementPeriodTime, Integer invoiceType) {
        return Optional.of(lQrWrapper()
                        .eq(SettlementOwner::getOrderNo, orderNo)
                        .eq(SettlementOwner::getSettlementPeriodType, SettlementOwnerEnum.SettlementPeriodType.MONTH.getCode())
                        .eq(SettlementOwner::getSettlementPeriodTime, settlementPeriodTime)
                        .eq(SettlementOwner::getInvoiceType, invoiceType)
                        .eq(SettlementOwner::getStatus, SettlementOwnerEnum.Status.TO_BE_LOCKED.getCode())
                )
                .map(super::getOne);
    }

    @Override
    public Optional<SettlementOwner> selectUnlockOfSettlementPeriodImmediate(String orderNo, Integer invoiceType) {
        return Optional.of(lQrWrapper()
                        .eq(SettlementOwner::getOrderNo, orderNo)
                        .eq(SettlementOwner::getSettlementPeriodType, SettlementOwnerEnum.SettlementPeriodType.IMMEDIATE.getCode())
                        .eq(SettlementOwner::getInvoiceType, invoiceType)
                        .eq(SettlementOwner::getStatus, SettlementOwnerEnum.Status.TO_BE_LOCKED.getCode())
                )
                .map(super::getOne);
    }

    @Override
    public List<SettlementOwner> listToBeLockOfSettlementPeriodMonth(LocalDateTime settlementPeriodTime) {
        return list(lQrWrapper()
                        .eq(SettlementOwner::getSettlementPeriodType, SettlementOwnerEnum.SettlementPeriodType.MONTH.getCode())
                        .lt(SettlementOwner::getSettlementPeriodTime, settlementPeriodTime)
                        .le(SettlementOwner::getStatus, SettlementOwnerEnum.Status.TO_BE_LOCKED.getCode())
                );
    }

    @Override
    public boolean uploadInvoiceImg(String settlementNo, String invoiceImg) {
        return update(lUdWrapper()
                .eq(SettlementOwner::getSettlementNo, settlementNo)
                .set(SettlementOwner::getInvoiceImg, invoiceImg)
        );
    }

    @Override
    public boolean saveExpress(String settlementNo, String expressCompany, String expressNo){
        return update(lUdWrapper()
                .eq(SettlementOwner::getSettlementNo, settlementNo)
                .set(SettlementOwner::getExpressCompany, expressCompany)
                .set(SettlementOwner::getExpressNo, expressNo)
        );
    }

    @Override
    public boolean savePayee(String settlementNo,
                               String payee,
                               String payeeBankName,
                               String payeeBankCardNo,
                               String paymentImg,
                               String paymentBankCardNo,
                               String paymentBankName,
                               String paymentAmount){
        return update(lUdWrapper()
                .eq(SettlementOwner::getSettlementNo, settlementNo)
                .set(SettlementOwner::getPayee, payee)
                .set(SettlementOwner::getPayeeBankName, payeeBankName)
                .set(SettlementOwner::getPayeeBankCardNo, payeeBankCardNo)
                .set(SettlementOwner::getPaymentImg, paymentImg)
                .set(SettlementOwner::getPaymentBankCardNo, paymentBankCardNo)
                .set(SettlementOwner::getPaymentBankName, paymentBankName)
                .set(SettlementOwner::getPaymentAmount, paymentAmount)
        );
    }

    @Override
    public boolean updateStatusByOrderNo(String orderNo, Integer settlementPeriodType,Integer fromStatus,Integer toStatus){
        return update(lUdWrapper()
                .eq(Objects.nonNull(orderNo),SettlementOwner::getOrderNo, orderNo)
                .eq(SettlementOwner::getSettlementPeriodType, settlementPeriodType)
                .eq(SettlementOwner::getStatus, fromStatus)
                .set(SettlementOwner::getStatus, toStatus)
        );
    }

}
