package com.clx.performance.service.impl;

import com.clx.performance.dao.OrderChildLogDao;
import com.clx.performance.enums.OrderChildLogEnum;
import com.clx.performance.model.OrderChildLog;
import com.clx.performance.service.OrderChildLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class OrderChildLogServiceImpl implements OrderChildLogService {

    @Autowired
    private OrderChildLogDao orderChildLogDao;

    @Override
    public void saveOrderChildLog(String childNo, Integer type, String remark,
                                  Integer createType,Long createBy, String createName) {

        OrderChildLog orderChildLog = new OrderChildLog();
        orderChildLog.setChildNo(childNo);
        orderChildLog.setType(type);
        orderChildLog.setRemark(remark);
        orderChildLog.setCreateType(createType);
        orderChildLog.setCreateBy(createBy);
        orderChildLog.setCreateName(createName);

        orderChildLogDao.saveEntity(orderChildLog);
    }

    @Override
    public void saveDriverOrderChildLog(String childNo, Integer type, String remark, Long createBy, String createName) {
        saveOrderChildLog(childNo, type, remark, OrderChildLogEnum.CreateType.DRIVER.getCode(), createBy, createName);
    }

    @Override
    public List<OrderChildLog> getOrderChildNodeLog(String childNo) {
        return orderChildLogDao.getOrderChildNodeLog(childNo);
    }

    @Override
    public void saveCarrierOrderChildLog(String childNo, Integer type, String remark, Long createBy, String createName) {
        saveOrderChildLog(childNo, type, remark, OrderChildLogEnum.CreateType.PLATFORM.getCode(), createBy, createName);

    }

    @Override
    public void saveBatchOrderChildLog(List<OrderChildLog> logs) {
        orderChildLogDao.saveBatchList(logs);
    }
}
