package com.clx.performance.vo.pc.loan.owner;

import com.clx.performance.enums.loan.OwnerLoanAccountRunningWaterRecordEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @ClassName OwnerLoanRunWaterRecordVO
 * @Description
 * @Author kavin
 * @Date 2024/1/23 13:21
 * @Version 1.0
 */
@Getter
@Setter
public class OwnerLoanRunWaterRecordVO {



    private Integer id;

    @Schema(description="货主编码")
    private String ownerUserNo;

    
    @Schema(description="货主名称")
    private String ownerUserName;

    
    @Schema(description="联系电话")
    private String mobile;

    
    @Schema(description="流水号")
    private Long runningWaterNo;

    
    @Schema(description="借款单号")
    private Long loanNo;

    
    @Schema(description="运单编号")
    private String childNo;

    
    @Schema(description="流水类型")
    private Integer runningWaterType;


    @Schema(description="流水类型")
    private String runningWaterTypeMsg;

    public String getRunningWaterTypeMsg() {
        return OwnerLoanAccountRunningWaterRecordEnum.RunWaterType.getMsgByCode(runningWaterType);
    }


    @MoneyOutConvert
    @Schema(description="金额")
    private BigDecimal alterationBalance;

    @MoneyOutConvert
    @Schema(description="账户余额")
    private BigDecimal accountBalance;

    @MoneyOutConvert
    @Schema(description="可用余额")
    private BigDecimal useAbleBalance;


    @MoneyOutConvert
    @Schema(description="冻结余额")
    private BigDecimal frozenBalance;

    @Schema(description="创建人")
    private String createBy;

    
    @Schema(description="创建时间")
    private String createTime;

    
    @Schema(description="修改时间")
    private String modifiedTime;
}
