package com.clx.performance.vo.pc.collect;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.time.LocalDateTime;
import java.util.List;

@Schema(description = "收集司机拉运意向问题")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CarrierDriverCollectTransportIntentionVO {
    private Integer id;

    @Schema(description="排序编号")
    private Integer sortNo;

    @Schema(description="问题名称")
    private String collectName;

    @Schema(description="问题描述")
    private String collectDescribe;

    @Schema(description="状态：1单选 2多选")
    private Integer collectCheckType;

    @Schema(description="状态：1拉运意向 2拒绝拉运")
    private Integer collectType;

    @Schema(description="操作人编码")
    private Long createUserNo;

    @Schema(description="操作人")
    private String createUserName;

    @Schema(description="删除状态: 0-否;1-是")
    private Integer deleteStatus;

    @Schema(description="状态：1启用 2禁用")
    private Integer status;

    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Schema(description = "收集司机拉运意向选项")
    private List<CarrierDriverCollectTransportIntentionRecordVO> collectIntentionRecordList;
}
