package com.clx.performance.param.pc;

import com.msl.common.convertor.type.MoneyInConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
public class OrderGoodsChildParams {

    @Schema(description = "用车方式 1：平台车辆配货 2：自有车辆配货", required = true)
    private String vehicleUsage;

    @NotNull(message = "挂单运费不能为空")
    @MoneyInConvert
    @Schema(description = "挂单运费", required = true)
    private BigDecimal pendingOrderFreight;

    @NotNull(message = "提取方式不能为空")
    @Schema(description = "提取方式 1提取全部 2提取部分", required = true)
    private Integer extractWay;

    @NotNull(message = "提取吨数不能为空")
    @Schema(description = "提取吨数", required = true)
    private BigDecimal extractWeight;

    @Schema(description = "需要车辆/辆", required = true)
    private Integer needTruckNum;

    @NotNull(message = "提取吨数不能为空")
    @Schema(description = "挂单方式  1公开派单  2定向派单  3车队公开派单  4车队定向派单" , required = true)
    private Integer pendingOrderWay;

    @NotBlank(message = "最晚接单时间不能为空")
    @Schema(description = "最晚接单时间", example = "2023-09-09 12:00:01", required = true)
    private String lastOrderTime;

    @NotBlank(message = "最晚到达货源地时间不能为空")
    @Schema(description = "最晚到达货源地时间", example = "2023-09-09 12:00:01", required = true)
    private String lastArriveSendTime;

    @NotBlank(message = "最晚装货时间不能为空")
    @Schema(description = "最晚装货时间", example = "2023-09-09 12:00:01", required = true)
    private String lastLoadTime;

    @NotBlank(message = "最晚到达目的地时间不能为空")
    @Schema(description = "最晚到达目的地时间", example = "2023-09-09 12:00:01", required = true)
    private String lastArriveReceiveTime;


    @NotBlank(message = "挂单时间不能为空")
    @Schema(description = "挂单时间", example = "2023-09-09 12:00:01", required = true)
    private String pendingOrderTime;

    @NotNull(message = "高级物流经理id不能为空")
    @Schema(description = "高级物流经理id" , required = true)
    private Integer seniorLogisticsManagerId;

    @NotBlank(message = "高级物流经理姓名能为空")
    @Schema(description = "高级物流经理姓名" , required = true)
    private String seniorLogisticsManagerName;


//    @Schema(description = "定向运单失效时间", example = "2023-09-09 12:00:01", required = true)
//    private String directionalExpireTime;

    @Schema(description="创建人用户编号")
    private Long userNo;

    @Schema(description="创建人姓名")
    private String userName;

    @Schema(description="车辆列表")
    private List<String> truckList;
}
