package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-10-17
 * Time 19:37
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("pending_freight")
public class PendingFreight implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("order_no")
    @Schema(description="订单编号")
    private String orderNo;

    @TableField("order_status")
    @Schema(description="订单状态")
    private Integer orderStatus;

    @TableField("send_address_id")
    @Schema(description="发货-地址id")
    private Integer sendAddressId;

    @TableField("send_address_shorter")
    @Schema(description="货源地简称")
    private String sendAddressShorter;

    @TableField("send_address")
    @Schema(description="煤源位置")
    private String sendAddress;


    @TableField("receive_address_id")
    @Schema(description="收货-地址id")
    private Integer receiveAddressId;

    @TableField("receive_address_shorter")
    @Schema(description="目的地简称")
    private String receiveAddressShorter;




    @TableField("senior_logistics_manager_name")
    @Schema(description="高级物流经理姓名数组")
    private String seniorLogisticsManagerName;

    @TableField("goods_name_id")
    @Schema(description="货物名称id")
    private Integer goodsNameId;

    @TableField("goods_name")
    @Schema(description="货物名称")
    private String goodsName;


    @TableField("goods_model")
    @Schema(description="热值名称")
    private String goodsModel;

    @TableField("send_over_standard")
    @Schema(description="是否C类煤源  0 否  1 是")
    private Integer sendOverStandard;

    @TableField("task_weight")
    @Schema(description="任务吨数")
    private BigDecimal taskWeight;

    @TableField("ordered_rate")
    @Schema(description="接单率")
    private BigDecimal orderedRate;

    @TableField("load_truck_rate")
    @Schema(description="装车率")
    private BigDecimal loadTruckRate;

    @TableField("order_distance")
    @Schema(description="重车运距(公里)")
    private BigDecimal orderDistance;

    @TableField("send_address_expenses")
    @Schema(description="煤源地开支")
    private String sendAddressExpenses;

    @TableField("history_freight")
    @Schema(description="历史运费")
    private BigDecimal historyFreight;

    @TableField("history_avg_freight")
    @Schema(description="历史平均运费")
    private BigDecimal historyAvgFreight;

    @TableField("prediction_freight_price")
    @Schema(description="测算运费")
    private BigDecimal predictionFreightPrice;

    @TableField("logistics_freight")
    @Schema(description="物流运费")
    private BigDecimal logisticsFreight;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
