package com.clx.performance.feign;

import com.clx.performance.param.feign.transport.*;
import com.msl.common.dto.HttpDTO;
import com.msl.common.result.Result;
import jakarta.validation.constraints.NotBlank;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = "transport-service-yitu", url = "${transport-service.host}", configuration = FeignInterceptor.class)
public interface TransportFeignService {

    /**
     * 运单同步
     */
    @PostMapping(value = "/transport-service/thirdParty/order/orderChildSync")
    HttpDTO orderChildSync(@RequestBody ThirdOrderChildBrokerParam param);

    /**
     * 获取风控状态
     * @return
     * @see ThirdOrderChildRiskStatusDTO
     */
    @PostMapping(value = "/transport-service/thirdParty/order/getRiskStatus")
    HttpDTO getRiskStatus(@RequestBody ThirdOrderChildRiskStatusParam param);

    /**
     * 运单支付运费同步
     */
    @PostMapping(value = "/transport-service/thirdParty/order/orderChildPaySync")
    HttpDTO orderChildPaySync(@RequestBody OrderChildPaySyncParam param);

    /**
     * 获取运单开票状态
     * @return
     * @see ThirdOrderChildInvoiceStatusDTO
     */
    @PostMapping(value = "/transport-service/thirdParty/order/getInvoiceStatus")
    HttpDTO getInvoiceStatus(@RequestBody ThirdOrderChildInvoiceStatusParam param);

    /**
     * 货主结算单同步 (只推同一货主)
     */
    @PostMapping(value = "/transport-service/thirdParty/order/ownerSettlementSync")
    HttpDTO ownerSettlementSync(@RequestBody OwnerSettlementSyncParam param);

    /**
     * 货主同步(法人模式)
     * @return 货主用户id
     */
    @PostMapping(value = "/transport-service/thirdParty/owner/ownerLegalSync")
    Result<Integer> ownerLegalSync(@RequestBody OwnerLegalSyncParam param);

    /**
     * 货主同步(自然人模式)
     * @return 货主用户id
     */
    @PostMapping(value = "/transport-service/thirdParty/owner/ownerPersonalSync")
    Result<Integer> ownerPersonalSync(@RequestBody OwnerPersonalSyncParam param);

    /**
     * 检测货主是否注册
     * @return 0不存在 1存在
     */
    @PostMapping(value = "/transport-service/thirdParty/owner/ownerExistCheck")
    Result<Integer> ownerExistCheck(@Validated @NotBlank(message = "手机不能为空") String mobile);

    /**
     * 获取货主用户id
     * @Return null未注册
     */
    @PostMapping(value = "/transport-service/thirdParty/owner/getOwnerId")
    Result<Integer> getOwnerId(@Validated @NotBlank(message = "手机不能为空") String mobile);

}
