package com.clx.performance.dao.impl.collect;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.collect.CollectDriverTransportIntentionDao;
import com.clx.performance.enums.collect.CollectDriverTransportIntentionEnum;
import com.clx.performance.mapper.collect.CollectDriverTransportIntentionMapper;
import com.clx.performance.model.collect.CollectDriverTransportIntention;
import com.clx.performance.param.app.collect.AppCarrierDriverCollectTransportIntentionParam;
import com.clx.performance.param.app.collect.CarrierDriverCollectTransportIntentionListParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Objects;

/**
 * @author kavin
 * Date 2024-10-17
 * Time 16:26
 */
@Repository
public class CollectDriverTransportIntentionDaoImpl extends BaseDaoImpl<CollectDriverTransportIntentionMapper, CollectDriverTransportIntention, Integer> implements CollectDriverTransportIntentionDao {

    @Override
    public IPage<CollectDriverTransportIntention> listByCondition(CarrierDriverCollectTransportIntentionListParam param) {
        LambdaQueryWrapper<CollectDriverTransportIntention> query = new LambdaQueryWrapper<>();

        if (StringUtils.isNotBlank(param.getCollectName())) {
            query.like(CollectDriverTransportIntention::getCollectName, param.getCollectName());
        }
        // 时间倒序排列
        query.orderByDesc(CollectDriverTransportIntention::getSortNo);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()), query);
    }

    @Override
    public IPage<CollectDriverTransportIntention> listEnableInfo(AppCarrierDriverCollectTransportIntentionParam param) {
        LambdaQueryWrapper<CollectDriverTransportIntention> query = new LambdaQueryWrapper<>();
        // 启用状态
        query.eq(CollectDriverTransportIntention::getStatus,
                CollectDriverTransportIntentionEnum.StatusType.STATUS_ENABLE.getCode());

        if (Objects.nonNull(param.getCollectType())) {
            query.eq(CollectDriverTransportIntention::getCollectType, param.getCollectType());
        }
        // 按照排序编号降序
        query.orderByDesc(CollectDriverTransportIntention::getSortNo);

        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()), query);
    }

    @Override
    public void updateRecordOrder(Long seq, boolean isUp) {
        LambdaUpdateWrapper<CollectDriverTransportIntention> update = new LambdaUpdateWrapper<>();
        if (isUp) {
            update.gt(CollectDriverTransportIntention::getSortNo, seq);
        } else {
            update.ge(CollectDriverTransportIntention::getSortNo, seq);
        }
        update.setSql("sort_no = sort_no + 1");
        baseMapper.update(null, update);
    }
}
