package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.carrier.PagePlatformAccountConfigParam;
import com.clx.performance.param.pc.carrier.SavePlatformAccountConfigParam;
import com.clx.performance.service.PlatformAccountConfigService;
import com.clx.performance.vo.pc.carrier.settle.*;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotNull;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/platformAccountConfig")
@Validated
@Tag(name = "承运端-平台账户配置")
@AllArgsConstructor
public class PlatformAccountConfigController {

    private final PlatformAccountConfigService platformAccountConfigService;

    @Operation(summary = "平台账户配置列表",description = "<br>By:姜文业")
    @PostMapping("/pagePlatformAccountConfig")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPagePlatformAccountConfigVO>> pagePlatformAccountConfig(@RequestBody @Validated PagePlatformAccountConfigParam param) {
        IPage<CarrierPagePlatformAccountConfigVO> page = platformAccountConfigService.pagePlatformAccountConfig(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @Operation(summary = "平台账户配置详情",description = "<br>By:姜文业")
    @GetMapping("/getPlatformAccountConfigDetail")
    @UnitCovert(param = false)
    public Result<CarrierPagePlatformAccountConfigVO> getPlatformAccountConfigDetail(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(platformAccountConfigService.getPlatformAccountConfigDetail(id));
    }

    @Operation(summary = "删除平台账户配置",description = "<br>By:姜文业")
    @GetMapping("/deletePlatformAccountConfig")
    @UnitCovert(param = false)
    public Result<CarrierPagePlatformAccountConfigVO> deletePlatformAccountConfig(@NotNull(message = "id不能为空") Integer id) {
        platformAccountConfigService.deletePlatformAccountConfig(id);
        return Result.ok();
    }

    @Operation(summary = "新增平台账户配置",description = "<br>By:姜文业")
    @PostMapping("/savePlatformAccountConfig")
    public Result savePlatformAccountConfig(@RequestBody @Validated SavePlatformAccountConfigParam param) {
        platformAccountConfigService.savePlatformAccountConfig(param);
        return Result.ok();
    }

    @Operation(summary = "编辑平台账户配置",description = "<br>By:姜文业")
    @PostMapping("/updatePlatformAccountConfig")
    public Result updatePlatformAccountConfig(@RequestBody @Validated SavePlatformAccountConfigParam param) {
        platformAccountConfigService.updatePlatformAccountConfig(param);
        return Result.ok();
    }

}
