package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverDetailParam;
import com.clx.performance.service.settle.SettlementDriverDetailService;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementDriverDetailVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletResponse;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/settlementDriverDetail")
@Validated
@Tag(name = "承运端-计费管理")
@AllArgsConstructor
public class CarrierSettlementDriverDetailController {

    private final SettlementDriverDetailService settlementDriverDetailService;


    @Operation(summary = "运单计费列表（车主）",description = "<br>By:刘海泉")
    @PostMapping("/pageSettlementDriverDetail")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPageSettlementDriverDetailVO>> pageSettlementDriverDetail(@RequestBody @Validated PageCarrierSettlementDriverDetailParam param) {
        IPage<CarrierPageSettlementDriverDetailVO> page = settlementDriverDetailService.pageSettlementDriverDetail(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @Operation(summary = "导出车主运单计费",description = "<br>By:杨启发")
    @PostMapping("/exportSettlementDriverDetail")
    public void exportSettlementDriverDetail(@RequestBody @Validated PageCarrierSettlementDriverDetailParam param, HttpServletResponse response) throws Exception {
        try (SXSSFWorkbook workbook = settlementDriverDetailService.exportSettlementDriverDetail(param)) {
            response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
            workbook.write(response.getOutputStream());
        }
    }
}
