package com.clx.performance.controller.pc;

import cn.hutool.json.JSONUtil;
import com.clx.performance.service.LargeScreenService;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import jakarta.validation.constraints.NotNull;

@Slf4j
@RestController
@RequestMapping("/pc/largescreen")
@Validated
@AllArgsConstructor
@Tag(name = "PC-大屏")
public class LargeScreenController {

    private final LargeScreenService largeScreenService;


    @Operation(summary = "空车列表", description = "<br>By:胡宇帆")
    @GetMapping("/emptyCarList")
    public String emptyCarList() {
        return JSONUtil.toJsonStr(largeScreenService.emptyCarList());
    }

    @Operation(summary = "重车列表", description = "<br>By:胡宇帆")
    @GetMapping("/weightCarList")
    public String weightCarList() {
        return JSONUtil.toJsonStr(largeScreenService.weightCarList());
    }

    @Operation(summary = "收货地址", description = "<br>By:胡宇帆")
    @GetMapping("/receiveAddress")
    public String receiveAddress(@RequestParam(value = "addressId")@NotNull Integer addressId) {
        return largeScreenService.receiveAddress(addressId);
    }

    @Operation(summary = "发货地址", description = "<br>By:胡宇帆")
    @GetMapping("/sendAddress")
    public String sendAddress(@RequestParam(value = "addressId") @NotNull Integer addressId) {
        return largeScreenService.sendAddress(addressId);
    }

    @Operation(summary = "线路", description = "<br>By:胡宇帆")
    @GetMapping("/lineString")
    public String lineString(@RequestParam(value = "addressId")@NotNull Integer addressId) {
        return largeScreenService.routeLine(addressId);
    }

}