package com.clx.performance.controller.app;

import com.clx.performance.service.DictionaryService;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import jakarta.validation.constraints.NotBlank;

@Slf4j
@RestController
@RequestMapping(value="/app/dictionary")
@Validated
@Tag(name = "承运司机端-字典")
@AllArgsConstructor
public class AppDictionaryController {

    private final DictionaryService dictionaryService;


    @Operation(summary = "字典",description = "<br>By:李瑞新")
    @GetMapping("/getOneByKey")
    public Result<String> getOneByKey(@NotBlank(message = "key不能为空") String key) {
        return Result.ok(dictionaryService.getOneByKey(key));
    }

}
