package com.clx.performance.component;


import cn.hutool.json.JSONUtil;
import com.clx.order.feign.OrderFeign;
import com.clx.performance.enums.OwnerAccountEnum;
import com.clx.performance.param.pc.owner.ThawAccountParam;
import com.clx.performance.service.OwnerAccountService;
import com.clx.performance.service.settle.SettlementOwnerDetailService;
import com.clx.performance.service.settle.SettlementOwnerService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
@AllArgsConstructor
public class OwnerAccountComponent {

    private final SettlementOwnerDetailService settlementOwnerDetailService;

    private final OwnerAccountService ownerAccountService;

    private final SettlementOwnerService settlementOwnerService;

    private final OrderFeign orderFeign;


    public void thawOwnerAccountByOrderNo(String orderNo) {
        Boolean flag = settlementOwnerDetailService.thawAndLockSettlement(orderNo);
        if (flag) {
            log.info("当前存在在途运单");
            orderFeign.saveOrderSettlementJobRecord(orderNo);
            return;
        }
        Integer invoiceType = settlementOwnerDetailService.getInvoiceType(orderNo);
        //1 网运单 2 普通单
        log.info("invoiceType={}", invoiceType);
        ThawAccountParam thawAccountParam = new ThawAccountParam();
        thawAccountParam.setOrderNo(orderNo);
        if (OwnerAccountEnum.OrderChildTypeStatus.ORDINARY.getCode().equals(invoiceType)) {
            log.info("执行普通单解冻");
            thawAccountParam.setOrderType(OwnerAccountEnum.OrderChildTypeStatus.ORDINARY.getCode());
        } else {
            log.info("执行网运单解冻");
            thawAccountParam.setOrderType(OwnerAccountEnum.OrderChildTypeStatus.NETWORK.getCode());
        }
        log.info("执行解冻账户,参数：{}", JSONUtil.parse(thawAccountParam));
        ownerAccountService.ownerAccountThaw(thawAccountParam);

        //通知结算单锁定
        settlementOwnerService.updateStatusByOrderNo(orderNo, 1, 10, 20);
    }
}
