package com.clx.performance.interceptor;

import com.clx.performance.feign.FeignUserService;
import com.msl.common.result.Result;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import java.util.Objects;

/**
 * @describe: 重写 feign调用的鉴权码
 */
@Configuration
@Slf4j
public class FeignConfiguration implements RequestInterceptor {


    @Autowired
    private FeignUserService feignUserService;

    @Override
    public void apply(RequestTemplate requestTemplate) {
        String url = requestTemplate.url();
        if (StringUtils.isBlank(url)){
            return;
        }
        if (url.startsWith("payment-service") || url.startsWith("/payment-service")) {
            Result<String> paymentServiceAuth = feignUserService.getPaymentServiceAuth();
            log.info("====feign服务调用，请求头信息重写=====feignAuth={}", paymentServiceAuth);
            if(paymentServiceAuth != null && Objects.equals(paymentServiceAuth.getCode(),0) && paymentServiceAuth.getData() !=null){
                requestTemplate.header("feignAuth", paymentServiceAuth.getData());
            }
        }

    }
}
