package com.clx.performance.feign;

import com.clx.performance.vo.pc.broker.TransportPayConfirmParam;
import com.clx.performance.vo.pc.broker.TransportParam;
import com.clx.performance.vo.pc.broker.TransportVO;
import com.msl.common.result.Result;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(name = "broker-service",configuration = PerformanceClientConfiguration.class,url = "${settlement.brokerHost}")
public interface BrokerFeign {

    /**
     * 运单同步
     */
    @PostMapping("/broker-service/open/transport/saveTransport")
    Result<Object> saveTransport(@RequestBody TransportParam param);

    /**
     * 运单更新
     */
    @PostMapping("/broker-service/open/transport/modifyTransport")
    Result<Object> modifyTransport(@RequestBody TransportParam param);

    @GetMapping("/broker-service/open/transport/getTransportByChildNo")
    Result<TransportVO> getTransportByChildNo(@RequestParam @NotBlank(message = "运单编号不能为空") String orderCode,
                                              @RequestParam @NotNull(message = "userCode不能为空") String userCode,
                                              @RequestParam String settlementNo);

    /**
     *  司机支付
     */
    @RequestMapping(value = "/broker-service/open/transport/payConfirm", method = RequestMethod.POST)
    Result<Object> payConfirm(@RequestBody TransportPayConfirmParam param);

}
