package com.clx.performance.dao.impl.linewarn;


import com.clx.performance.dao.linewarn.LineWarnOrderGoodsDao;
import com.clx.performance.enums.linewarn.LineWarnOrderGoodsEnum;
import com.clx.performance.mapper.linewarn.LineWarnOrderGoodsMapper;
import com.clx.performance.model.linewarn.LineWarnOrderGoods;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class LineWarnOrderGoodsDaoImpl extends BaseDaoImpl<LineWarnOrderGoodsMapper, LineWarnOrderGoods, Integer> implements LineWarnOrderGoodsDao {

    @Override
    public boolean updateWarnStatus(LineWarnOrderGoods item) {
        return update(lUdWrapper()
                .eq(LineWarnOrderGoods::getId, item.getId())
                .set(LineWarnOrderGoods::getWarnStatus, item.getWarnStatus())
        );
    }

    @Override
    public Optional<LineWarnOrderGoods> getByOrderGoodsNo(String orderGoodsNo) {
        return Optional.of(orderGoodsNo)
                .map(item -> lQrWrapper()
                        .eq(LineWarnOrderGoods::getOrderGoodsNo, orderGoodsNo)
                )
                .map(super::getOne);
    }

    @Override
    public List<LineWarnOrderGoods> ListOrderGoodsNoOfWarn() {
        return list(lQrWrapper().select(LineWarnOrderGoods::getOrderGoodsNo)
                .eq(LineWarnOrderGoods::getWarnStatus, LineWarnOrderGoodsEnum.WarnStatus.ENABLE.getCode())
                .orderByDesc(LineWarnOrderGoods::getId)
                .last("limit 10000")
        );

    }
}
