package com.clx.performance.controller.feign;

import com.clx.performance.service.PlatformServiceFeeConfigService;
import com.clx.performance.vo.feign.PlatformServiceFeeConfigFeignVO;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/feign/platformServiceFee")
@Validated
@Tag(name = "平台服务费Feign")
public class PlatformServiceFeeFeignController {

    @Autowired
    private PlatformServiceFeeConfigService platformServiceFeeConfigService;

    @GetMapping(value = {"/getPlatformServiceFeeConfig"})
    Result<PlatformServiceFeeConfigFeignVO> getPlatformServiceFeeConfig(){

        return Result.ok(platformServiceFeeConfigService.getConfig());

    }

}
