package com.clx.performance.param.pc.vehiclewarn;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

@Getter
@Setter
@NoArgsConstructor
public class VehicleWarnConfigUpdateParam {

    @Schema(description = "id", example = "1")
    @NotNull(message = "id不能为空")
    private Integer id;

    @Schema(description = "预警方案名称", example = "方案1")
    @NotBlank(message = "预警方案名称不能为空")
    private String warnName;
    @Schema(description = "预警类型", example = "1")
    @NotNull(message = "预警类型不能为空")
    private Integer warnType;
    @Schema(description = "预警级别: 1一级 2二级 3三级", example = "1")
    @NotNull(message = "预警级别不能为空")
    private Integer warnLevel;

    @Schema(description = "预警间隔（小时）", example = "1.2")
    private BigDecimal interval;
    @Schema(description = "超时比例（%）", example = "12.3")
    private BigDecimal timeoutRatio;
    @Schema(description = "经度", example = "123.45")
    private BigDecimal longitude;
    @Schema(description = "纬度", example = "12.34")
    private BigDecimal latitude;
    @Schema(description = "地址", example = "北京")
    private String address;
    @Schema(description = "半径（米）", example = "123")
    private Integer radius;

}
