package com.clx.performance.param.pc.breakcontract.carrier;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotNull;
import java.util.Map;

/**
 * @Author: aiqingguo
 * @Date: 2023-10-11 17:30:57
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class BreakContractOwnerRuleAddParam {

    @Schema(description = "违约方案名称", example = "方案1")
    @NotNull(message = "违约方案名称不能为空")
    private String name;

    @Schema(description = "自动规则")
    private Map<String, String> rule;

}
