package com.clx.performance.param.pc;

import com.msl.common.convertor.type.MoneyInConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderGoodsEditParams {

    private Integer id;

    @Schema(description="货单编号")
    private String orderGoodsNo;

    @Schema(description="用车方式 1：平台车辆配货 2：自有车辆配货")
    private Integer vehicleUsage;

    @Schema(description="提取吨数")
    private BigDecimal extractWeight;

    @Schema(description="剩余拉运吨数")
    private BigDecimal residueTransportWeight;

    @Schema(description="挂单方式  1公开派单  2定向派单  3车队公开派单  4车队定向派单")
    private Integer pendingOrderWay;

    @Schema(description="'最晚接单时间'")
    private String lastOrderTime;
    
    @Schema(description="最晚到达货源地时间")
    private String lastArriveSendTime;

    @Schema(description="最晚装货时间")
    private String lastLoadTime;

    @Schema(description="最晚到达目的地时间")
    private String lastArriveReceiveTime;

    @Schema(description="挂单时间")
    private String pendingOrderTime;
    
    @Schema(description="提取方式 1提取全部 2提取部分")
    private Integer extractWay;

    @Schema(description="需要车辆/辆")
    private Integer needTruckNum;

    @Schema(description="挂单运费")
    @MoneyInConvert
    private BigDecimal pendingOrderFreight;

    @Schema(description="创建人用户编号")
    private Long userNo;

    @Schema(description="创建人姓名")
    private String userName;

    @Schema(description="修改时间")
    private String modifiedTime;

    @Schema(description="车辆列表")
    private List<String> truckList;
}
