package com.clx.performance.param.app.collect;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

@Getter
@Setter
@NoArgsConstructor
public class CollectTruckLocationSaveParam {

    @Schema(description = "车牌号", example = "京A12345")
    @NotBlank(message = "车牌号不能为空")
    private String truckNo;

    @Schema(description = "车辆出车状态 1:空车 2重车", example = "1")
    @NotNull(message = "车辆出车状态不能空")
    private Integer truckOrderStatus;

    @Schema(description = "经度")
    private BigDecimal longitude;
    @Schema(description = "纬度")
    private BigDecimal latitude;

    @Schema(description = "省", example = "")
    private String province;
    @Schema(description = "市", example = "")
    private String city;
    @Schema(description = "区县", example = "")
    private String county;
    @Schema(description = "乡镇", example = "")
    private String town;
    @Schema(description = "街道", example = "")
    private String street;
    @Schema(description = "详细地址", example = "北京路1号")
    private String address;
    @Schema(description = "司机手填地址", example = "北京路1号")
    private String locationRemark;

}
