package com.clx.performance.vo.pc.loan.owner;

import com.clx.performance.enums.loan.OwnerRePaymentEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.math.BigDecimal;

/**
 * @ClassName OrderPaymentDetailVO
 * @Description
 * @Author kavin
 * @Date 2024/1/24 16:45
 * @Version 1.0
 */

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class OwnerOrderPaymentDetailVO {


    @Schema(description="还款单号")
    private Long repaymentNo;

    @Schema(description="借款单号")
    private Long loanNo;

    @Schema(description="付款方")
    private String payment;

    @Schema(description="付款账户")
    private String paymentAccount;

    @Schema(description="收款方")
    private String payee;

    @Schema(description="收款账户")
    private String payeeAccount;

    @MoneyOutConvert
    @Schema(description="订单金额")
    private BigDecimal repaymentBalance;



    @Schema(description="订单支付状态 10 待付款 40 付款中 50 付款成功 60 付款失败")
    private Integer status;

    @Schema(description="订单支付状态 10 待付款 40 付款中 50 付款成功 60 付款失败")
    private String statusMsg;

    public String getStatusMsg(){
        return OwnerRePaymentEnum.Status.getMsgByCode(status);
    }

    @Schema(description="付款最终时间")
    public String finalPaymentTime;


    @Schema(description="订单创建时间")
    public String createTime;

}
