package com.clx.performance.param.app;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;

/**
 * 装车范围校验检查参数
 */
@Getter
@Setter
@NoArgsConstructor
public class NeedAlertSuperviseInfoParam {

    @Schema(description = "运单编号", example = "100000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;


    @Schema(description = "类型 1-监装 2-监卸", example = "1")
    @NotNull(message = "类型不能为空")
    private Integer type;

}
