package com.clx.performance.dto.payment;

import com.fasterxml.jackson.annotation.JsonGetter;
import io.swagger.v3.oas.annotations.media.Schema;

import java.math.BigDecimal;


/**
 *
 * @author 胡宁宁
 * @date 2024年06
 * @description
 */
public class WalletResidueCardDTO extends WalletResidueDTO{
	@Schema(description = "消费卡余额", example = "11.10")
	private Long cardResidue;
	@Schema(description = "消费卡总数", example = "1")
	private Integer cardSum;
	@Schema(description = "昨天收益", example = "11.10")
	private BigDecimal yesterdayIncome;
	@Schema(description = "今日收益", example = "11.10")
	private BigDecimal todayIncome;
	@Schema(description = "本月收益", example = "11.10")
	private BigDecimal monthIncome;
	@Schema(description = "消费卡冻结余额", example = "11.10")
	private Long cardFrozen;
	@Schema(description = "绑定的银行卡数量", example = "0")
	private int cardCount;

	@Schema(description = "总资产", example = "0.00")
	private BigDecimal assetSum = BigDecimal.ZERO;

	public BigDecimal getAssetSum() {
		return assetSum;
	}

	public void setAssetSum(BigDecimal assetSum) {
		this.assetSum = assetSum;
	}

	public int getCardCount() { return cardCount; }

	public void setCardCount(int cardCount) { this.cardCount = cardCount; }

	@JsonGetter(value="cardResidue")
	public Double cardResidueFormat() {
		if(cardResidue == null ) return 0D;
		return Double.valueOf(this.cardResidue)/100;
	}

	@JsonGetter(value="cardFrozen")
	public Double cardFrozenFormat() {
		if(cardFrozen == null ) return 0D;
		return Double.valueOf(this.cardFrozen)/100;
	}
	
	public Long getCardResidue() {
		return cardResidue;
	}
	public void setCardResidue(Long cardResidue) {
		this.cardResidue = cardResidue;
	}
	public Integer getCardSum() {
		return cardSum;
	}
	public void setCardSum(Integer cardSum) {
		this.cardSum = cardSum;
	}

	public BigDecimal getYesterdayIncome() {
		return yesterdayIncome;
	}

	public void setYesterdayIncome(BigDecimal yesterdayIncome) {
		this.yesterdayIncome = yesterdayIncome;
	}

	public BigDecimal getMonthIncome() {
		return monthIncome;
	}

	public void setMonthIncome(BigDecimal monthIncome) {
		this.monthIncome = monthIncome;
	}

	public BigDecimal getTodayIncome() {
		return todayIncome;
	}

	public void setTodayIncome(BigDecimal todayIncome) {
		this.todayIncome = todayIncome;
	}

	public Long getCardFrozen() {
		return cardFrozen;
	}

	public void setCardFrozen(Long cardFrozen) {
		this.cardFrozen = cardFrozen;
	}
}
