package com.clx.performance.param.pc.integral;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Author: aiqingguo
 * @Description: 新增积分
 * @Date: 2023-10-11 17:30:57
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class IntegralTruckRuleUpdateParam {

    @Schema(description = "id", example = "")
    @NotNull(message = "id不能为空")
    private Integer id;
    @Schema(description = "层级名称", example = "")
    @NotBlank(message = "名称不能为空")
    private String name;
    @Schema(description = "积分起始范围", example = "")
    private Integer integralRatioBegin;
    @Schema(description = "积分结束范围", example = "")
    private Integer integralRatioEnd;
    @Schema(description = "状态：1开启 2关闭", example = "")
    private Integer status;
    @Schema(description = "预期收益开始范围（分）", example = "")
    private BigDecimal incomeBegin;
    @Schema(description = "预期收益结束范围（分）", example = "")
    private BigDecimal incomeEnd;

}
