package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;

import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;


/**
 * @author yangqifa
 */
@Data
public class OcrRecognition implements HasKey<Integer> {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "主键ID")
    private Integer id;

    /**
     * 运单编号
     */
    @Schema(description = "运单编号")
    private String childNo;

    /**
     * 图片类型,1:装车磅单,2:卸车磅单
     */
    @Schema(description = "图片类型,1:装车磅单,2:卸车磅单")
    private Integer imageType;

    /**
     * 磅单图片url
     */
    @Schema(description = "磅单图片url")
    private String imageUrl;

    /**
     * 毛重
     */
    @Schema(description = "毛重")
    private BigDecimal grossWeight;

    /**
     * 皮重
     */
    @Schema(description = "皮重")
    private BigDecimal tareWeight;

    /**
     * OCR识别的原始结果
     */
    @Schema(description = "OCR识别的原始结果")
    private String originalResult;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    private Date createdTime;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    private Date modifiedTime;

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}