package com.clx.performance.sqlProvider;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.param.app.PageOrderChildOfDriverParam;
import com.clx.performance.param.app.PageOrderChildOfDriverSearchParam;
import com.clx.performance.param.pc.OrderChildCancelRecordParam;
import com.clx.performance.param.pc.PageCarrierOrderChildParam;
import com.clx.performance.param.pc.PagePoundAuditParam;
import com.clx.performance.vo.app.OrderChildVO;
import com.clx.performance.vo.pc.PageCarrierOrderChildVO;
import com.clx.performance.vo.pc.PageOrderChildPoundAuditVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

public class OrderChildSqlProvider {

    public String pageOrderChildOfDriver(@Param("page") Page<OrderChildVO> page, @Param("param") PageOrderChildOfDriverParam param) {
        return new SQL(){{
            SELECT("child_no,goods_name,freight_price," +
                    "send_address,receive_address," +
                    "driver_user_no, driver_name,driver_mobile," +
                    "truck_no," +
                    "unload_pound_no,weight," +
                    "cancel_remark," +
                    "pound_status,status," +
                    "date_format(load_deadline, '%Y-%m-%d %H:%i:%s') as loadDeadline," +
                    "date_format(unload_time, '%Y-%m-%d %H:%i:%s') as unloadTime "
            );
            FROM("order_child ");
            WHERE("(driver_user_no = #{param.userNo} or truck_own_user_no = #{param.userNo}) ");

            if (Objects.isNull(param.getStatus())) {

            }
            else if (param.getStatus() == 1){   //运输中
                WHERE("status in (" + StringUtils.join(OrderChildEnum.TRANSIT_lIST, ",")+")");
            }
            else if (param.getStatus() == 2){   //完成
                WHERE("status in (" + StringUtils.join(OrderChildEnum.FINISH_lIST, ",")+")");
            }
            else if (param.getStatus() == 3){   //已结算
                WHERE("status in (" + StringUtils.join(OrderChildEnum.SETTLE_lIST, ",")+")");
            }
            else if (param.getStatus() == 4){   //取消
                WHERE("status in (" + StringUtils.join(OrderChildEnum.CANCEL_lIST, ",")+")");
            }

            ORDER_BY("create_time desc");
        }}.toString();
    }
    public String pageSearchOrderChildOfDriver(@Param("page") Page<OrderChildVO> page, @Param("param") PageOrderChildOfDriverSearchParam param) {
        return new SQL(){{
            SELECT("child_no,goods_name,freight_price," +
                    "send_address,receive_address," +
                    "driver_user_no, driver_name,driver_mobile," +
                    "truck_no," +
                    "unload_pound_no,weight," +
                    "cancel_remark," +
                    "pound_status,status," +
                    "date_format(load_deadline, '%Y-%m-%d %H:%i:%s') as loadDeadline," +
                    "date_format(unload_time, '%Y-%m-%d %H:%i:%s') as unloadTime "
            );
            FROM("order_child ");
            WHERE("(user_no = #{param.userNo} or driver_user_no = #{param.userNo}) ");
            if (StringUtils.isNotBlank(param.getContent())) {WHERE("(" +
                    "    owner_name like CONCAT(#{param.content},'%') " +
                    " or truck_no like CONCAT(#{param.content},'%') " +
                    " or driver_name like CONCAT(#{param.content},'%') " +
                    " or send_address like CONCAT(#{param.content},'%') " +
                    " or receive_address like CONCAT(#{param.content},'%') " +
                    ")");}


            ORDER_BY("create_time desc");
        }}.toString();
    }

    public String pagePoundAuditList(@Param("page") Page<PageOrderChildPoundAuditVO> page, @Param("param") PagePoundAuditParam param) {
        return new SQL(){{
            SELECT("child_no,pound_status as status,goods_name,send_address,receive_address,driver_name,driver_mobile,load_net,unload_net," +
                    "date_format(pay_time, '%Y-%m-%d %H:%i:%s') as payTime," +
                    "date_format(load_time, '%Y-%m-%d %H:%i:%s') as loadTime," +
                    "date_format(unload_time, '%Y-%m-%d %H:%i:%s') as unloadTime ");
            FROM("order_child ");
            WHERE("pound_status >=0");
            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("pay_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("pay_time <= #{param.endTime}");}

            if (StringUtils.isNotBlank(param.getChildNo())) {WHERE("child_no = #{param.childNo}");}
            if (StringUtils.isNotBlank(param.getDriverName())) {WHERE("driver_name= #{param.driverName}");}
            if (StringUtils.isNotBlank(param.getDriverMobile())) {WHERE("driver_mobile = #{param.driverMobile}");}

            if (StringUtils.isNotBlank(param.getSendAddress())) {WHERE("send_address = #{param.sendAddress}");}
            if (StringUtils.isNotBlank(param.getReceiveAddress())) {WHERE("receive_address= #{param.receiveAddress}");}
            if (Objects.nonNull(param.getStatus())) {WHERE("pound_status = #{param.status}");}

            ORDER_BY("pound_status,unload_time");
        }}.toString();
    }


    public String pageCarrierOrderChildList(@Param("page") Page<PageCarrierOrderChildVO> page, @Param("param") PageCarrierOrderChildParam param) {
        return new SQL(){{
            SELECT("child_no,order_goods_no,status,goods_name,freight_price,send_address,receive_address,driver_name,driver_mobile,load_net,unload_net," +
                    "date_format(pay_time, '%Y-%m-%d %H:%i:%s') as payTime," +
                    "date_format(finish_time, '%Y-%m-%d %H:%i:%s') as finishTime");
            FROM("order_child ");
            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("pay_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("pay_time <= #{param.endTime}");}

            if (StringUtils.isNotBlank(param.getChildNo())) {WHERE("child_no = #{param.childNo}");}
            if (StringUtils.isNotBlank(param.getDriverName())) {WHERE("driver_name= #{param.driverName}");}
            if (StringUtils.isNotBlank(param.getDriverMobile())) {WHERE("driver_mobile = #{param.driverMobile}");}

            if (StringUtils.isNotBlank(param.getSendAddress())) {WHERE("send_address = #{param.sendAddress}");}
            if (StringUtils.isNotBlank(param.getReceiveAddress())) {WHERE("receive_address= #{param.receiveAddress}");}
            if (Objects.nonNull(param.getStatus())) {WHERE("status = #{param.status}");}

            ORDER_BY("id desc");
        }}.toString();
    }


    public String batchUpdateOrderChildStatus(@Param(value ="status") Integer status, @Param(value ="remark") String remark,
                                              @Param(value = "cancelTime") String cancelTime, @Param(value = "finishTime") String finishTime,
                                              @Param(value = "childNoList") List<String> childNoList ){
        StringBuffer sqlList = new StringBuffer();

        sqlList.append("update order_child set cancel_remark = '"+ remark +"' ,status = " + status + ",cancel_time = '"
                + cancelTime +"',finish_time = '" + finishTime + "'  where child_no in (");
        for (int i = 0; i < childNoList.size(); i++) {
            String childNo = childNoList.get(i);

            sqlList.append("'").append(childNo).append("'");

            if (i < childNoList.size() - 1) {
                sqlList.append(",");
            }
        }
        sqlList.append(")");
        return sqlList.toString();
    }

    public String findArtificialCancelOrder(@Param("orderChildNo") String orderChildNo) {
        String sql = "select child_no,goods_name,freight_price,order_no" +
                "send_address,receive_address," +
                "driver_user_no, driver_name,driver_mobile," +
                "truck_no," +
                "unload_pound_no,weight," +
                "cancel_remark," +
                "pound_status,status," +
                "date_format(load_deadline, '%Y-%m-%d %H:%i:%s') as loadDeadline," +
                "date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime," +
                "date_format(unload_time, '%Y-%m-%d %H:%i:%s') as unloadTime  from order_child where child_no = #{orderChildNo}";

        sql += " and status >="+ OrderChildEnum.Status.LOAD.getCode();
        sql += " and status <="+ OrderChildEnum.Status.UNSETTLE.getCode();
        return sql;
    }

    public String orderChildCancelRecord(@Param("page") Page<OrderChildVO> page, @Param("param") OrderChildCancelRecordParam param) {
        return new SQL(){{
            SELECT("child_no,goods_name,freight_price," +
                    "send_address,receive_address," +
                    "driver_user_no, driver_name,driver_mobile," +
                    "truck_no," +
                    "unload_pound_no,weight," +
                    "cancel_remark,order_no," +
                    "pound_status,status," +
                    "date_format(load_deadline, '%Y-%m-%d %H:%i:%s') as loadDeadline," +
                    "date_format(load_deadline, '%Y-%m-%d %H:%i:%s') as loadDeadline," +
                    "date_format(cancel_time, '%Y-%m-%d %H:%i:%s') as cancelTime "
            );
            FROM("order_child ");

            WHERE("status in (" + StringUtils.join(OrderChildEnum.CANCEL_lIST, ",")+")");


            ORDER_BY("create_time desc");
        }}.toString();
    }


}
