package com.clx.performance.service.impl.collect;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dao.collect.CollectLineReportDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.integral.IntegralRecordEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.collect.CollectLineReport;
import com.clx.performance.param.app.collect.*;
import com.clx.performance.param.pc.carrier.*;
import com.clx.performance.service.IntegralRecordService;
import com.clx.performance.service.collect.CollectLineReportService;
import com.clx.performance.service.integral.IntegralRuleService;
import com.clx.performance.struct.collect.CollectLineReportStruct;
import com.clx.performance.vo.pc.collect.CollectLineReportVO;
import com.clx.performance.vo.pc.integral.AppIntegralRuleVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.Objects;

@Slf4j
@Service
public class CollectLineReportServiceImpl implements CollectLineReportService {

    @Autowired
    private CollectLineReportDao collectLineReportDao;
    @Autowired
    private OrderChildDao orderChildDao;
    @Autowired
    private OrderGoodsDao orderGoodsDao;

    @Autowired
    private CollectLineReportStruct collectLineReportStruct;
    @Autowired
    private IntegralRuleService integralRuleService;
    @Autowired
    private IntegralRecordService integralRecordService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveSendAddressReport(CollectLineReportSendAddressSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        CollectLineReport collectLineReport = new CollectLineReport();
        collectLineReport.setUserNo(userNo);
        collectLineReport.setName(loginUserInfo.getUserName());
        collectLineReport.setMobile(loginUserInfo.getUserMobile());
        collectLineReport.setTruckNo(orderChild.getTruckNo());

        collectLineReport.setChildNo(param.getChildNo());
        collectLineReport.setSendAddressId(orderChild.getSendAddressId());
        collectLineReport.setSendAddress(orderChild.getSendAddress());
        collectLineReport.setReceiveAddressId(orderChild.getReceiveAddressId());
        collectLineReport.setReceiveAddress(orderChild.getReceiveAddress());

        collectLineReport.setType(CollectLineReport.Type.SEND.getCode());
        collectLineReport.setReportType(CollectLineReport.ReportType.SEND_ADDRESS.getCode());

        Integer reportStatus;
        if (param.getReportStatus() == 2){
            reportStatus = 1;
        }
        else {
            if (param.getStatus() == 1){reportStatus = 2;}
            else {reportStatus = 3;}
        }

        collectLineReport.setReportStatus(reportStatus);
        collectLineReport.setRemark(reportStatus==1? "否" : (reportStatus==2? "有存煤" : "现产现装"));
        collectLineReport.setReportTime(LocalDateTime.now());
        collectLineReport.setCreateTime(collectLineReport.getReportTime());
        collectLineReportDao.saveEntity(collectLineReport);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveAbnormalReport(CollectLineReportAbnormalSaveParam param) {

        if (Objects.equals(param.getReportType(), CollectLineReport.ReportType.UNABLE_TO_SEND_ADDRESS.getCode())){
            saveSendAddressAbnormalReport(new CollectLineReportSendAddressAbnormalSaveParam(param.getChildNo(), param.getRemark()));
        }
        else if (Objects.equals(param.getReportType(), CollectLineReport.ReportType.UNABLE_LOAD.getCode())){
            saveLoadAbnormalReport(new CollectLineReportLoadAbnormalSaveParam(param.getChildNo(), param.getRemark()));
        }
        else if (Objects.equals(param.getReportType(), CollectLineReport.ReportType.UNABLE_TO_RECEIVE_ADDRESS.getCode())){
            saveReceiveAddressAbnormalReport(new CollectLineReportReceiveAddressAbnormalSaveParam(param.getChildNo(), param.getRemark()));
        }
        else if (Objects.equals(param.getReportType(), CollectLineReport.ReportType.LOAD_UNLOAD.getCode())){
            saveLoadUnloadAbnormalReport(new CollectLineReportLoadUnloadAbnormalSaveParam(param.getChildNo(), param.getRemark()));
        }

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public CollectLineReport saveSendAddressAbnormalReport(CollectLineReportSendAddressAbnormalSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        CollectLineReport collectLineReport = new CollectLineReport();
        collectLineReport.setUserNo(userNo);
        collectLineReport.setName(loginUserInfo.getUserName());
        collectLineReport.setMobile(loginUserInfo.getUserMobile());
        collectLineReport.setTruckNo(orderChild.getTruckNo());

        collectLineReport.setChildNo(param.getChildNo());
        collectLineReport.setSendAddressId(orderChild.getSendAddressId());
        collectLineReport.setSendAddress(orderChild.getSendAddress());
        collectLineReport.setReceiveAddressId(orderChild.getReceiveAddressId());
        collectLineReport.setReceiveAddress(orderChild.getReceiveAddress());

        collectLineReport.setType(CollectLineReport.Type.SEND.getCode());
        collectLineReport.setReportType(CollectLineReport.ReportType.UNABLE_TO_SEND_ADDRESS.getCode());

        collectLineReport.setReportStatus(CollectLineReport.ReportStatus.ABNORMAL.getCode());
        collectLineReport.setRemark(param.getRemark());
        collectLineReport.setReportTime(LocalDateTime.now());
        collectLineReport.setCreateTime(collectLineReport.getReportTime());
        collectLineReportDao.saveEntity(collectLineReport);

        return collectLineReport;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public CollectLineReport saveLoadAbnormalReport(CollectLineReportLoadAbnormalSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        CollectLineReport collectLineReport = new CollectLineReport();
        collectLineReport.setUserNo(userNo);
        collectLineReport.setName(loginUserInfo.getUserName());
        collectLineReport.setMobile(loginUserInfo.getUserMobile());
        collectLineReport.setTruckNo(orderChild.getTruckNo());

        collectLineReport.setChildNo(param.getChildNo());
        collectLineReport.setSendAddressId(orderChild.getSendAddressId());
        collectLineReport.setSendAddress(orderChild.getSendAddress());
        collectLineReport.setReceiveAddressId(orderChild.getReceiveAddressId());
        collectLineReport.setReceiveAddress(orderChild.getReceiveAddress());

        collectLineReport.setType(CollectLineReport.Type.SEND.getCode());
        collectLineReport.setReportType(CollectLineReport.ReportType.UNABLE_LOAD.getCode());

        collectLineReport.setReportStatus(CollectLineReport.ReportStatus.ABNORMAL.getCode());
        collectLineReport.setRemark(param.getRemark());
        collectLineReport.setReportTime(LocalDateTime.now());
        collectLineReport.setCreateTime(collectLineReport.getReportTime());
        collectLineReportDao.saveEntity(collectLineReport);

        return collectLineReport;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public CollectLineReport saveReceiveAddressAbnormalReport(CollectLineReportReceiveAddressAbnormalSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        CollectLineReport collectLineReport = new CollectLineReport();
        collectLineReport.setUserNo(userNo);
        collectLineReport.setName(loginUserInfo.getUserName());
        collectLineReport.setMobile(loginUserInfo.getUserMobile());
        collectLineReport.setTruckNo(orderChild.getTruckNo());

        collectLineReport.setChildNo(param.getChildNo());
        collectLineReport.setSendAddressId(orderChild.getSendAddressId());
        collectLineReport.setSendAddress(orderChild.getSendAddress());
        collectLineReport.setReceiveAddressId(orderChild.getReceiveAddressId());
        collectLineReport.setReceiveAddress(orderChild.getReceiveAddress());

        collectLineReport.setType(CollectLineReport.Type.RECEIVE.getCode());
        collectLineReport.setReportType(CollectLineReport.ReportType.UNABLE_TO_RECEIVE_ADDRESS.getCode());

        collectLineReport.setReportStatus(CollectLineReport.ReportStatus.ABNORMAL.getCode());
        collectLineReport.setRemark(param.getRemark());
        collectLineReport.setReportTime(LocalDateTime.now());
        collectLineReport.setCreateTime(collectLineReport.getReportTime());
        collectLineReportDao.saveEntity(collectLineReport);

        return collectLineReport;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public CollectLineReport saveLoadUnloadAbnormalReport(CollectLineReportLoadUnloadAbnormalSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        CollectLineReport collectLineReport = new CollectLineReport();
        collectLineReport.setUserNo(userNo);
        collectLineReport.setName(loginUserInfo.getUserName());
        collectLineReport.setMobile(loginUserInfo.getUserMobile());
        collectLineReport.setTruckNo(orderChild.getTruckNo());

        collectLineReport.setChildNo(param.getChildNo());
        collectLineReport.setSendAddressId(orderChild.getSendAddressId());
        collectLineReport.setSendAddress(orderChild.getSendAddress());
        collectLineReport.setReceiveAddressId(orderChild.getReceiveAddressId());
        collectLineReport.setReceiveAddress(orderChild.getReceiveAddress());

        collectLineReport.setReportType(CollectLineReport.ReportType.LOAD_UNLOAD.getCode());

        collectLineReport.setReportStatus(CollectLineReport.ReportStatus.ABNORMAL.getCode());
        collectLineReport.setRemark(param.getRemark());
        collectLineReport.setReportTime(LocalDateTime.now());
        collectLineReport.setCreateTime(collectLineReport.getReportTime());
        collectLineReportDao.saveEntity(collectLineReport);

        return collectLineReport;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveNoTakeOrderAbnormalReport(CollectLineReportNoTakeOrderAbnormalSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        OrderGoods orderGoods = orderGoodsDao.getByOrderGoodsNo(param.getOrderGoodsNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        CollectLineReport collectLineReport = new CollectLineReport();
        collectLineReport.setUserNo(userNo);
        collectLineReport.setName(loginUserInfo.getUserName());
        collectLineReport.setMobile(loginUserInfo.getUserMobile());

        collectLineReport.setOrderGoodsNo(param.getOrderGoodsNo());
        collectLineReport.setSendAddressId(orderGoods.getSendAddressId());
        collectLineReport.setSendAddress(orderGoods.getSendAddressShorter());
        collectLineReport.setReceiveAddressId(orderGoods.getReceiveAddressId());
        collectLineReport.setReceiveAddress(orderGoods.getReceiveAddressShorter());

        collectLineReport.setType(CollectLineReport.Type.SEND.getCode());
        collectLineReport.setReportType(CollectLineReport.ReportType.NO_TAKE_ORDER.getCode());

        collectLineReport.setReportStatus(CollectLineReport.ReportStatus.ABNORMAL.getCode());
        collectLineReport.setRemark(param.getRemark());
        collectLineReport.setReportTime(LocalDateTime.now());
        collectLineReport.setCreateTime(collectLineReport.getReportTime());
        collectLineReportDao.saveEntity(collectLineReport);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveOtherReport(CollectLineReportOtherSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        CollectLineReport collectLineReport = new CollectLineReport();
        collectLineReport.setUserNo(userNo);
        collectLineReport.setName(loginUserInfo.getUserName());
        collectLineReport.setMobile(loginUserInfo.getUserMobile());

        collectLineReport.setType(CollectLineReport.Type.SEND.getCode());
        collectLineReport.setReportType(CollectLineReport.ReportType.OTHER.getCode());

        collectLineReport.setReportStatus(CollectLineReport.ReportStatus.NORMAL.getCode());
        collectLineReport.setRemark(param.getRemark());
        collectLineReport.setImage(param.getImageList()==null? null:JSON.toJSONString(param.getImageList()));
        collectLineReport.setReportTime(LocalDateTime.now());
        collectLineReport.setCreateTime(collectLineReport.getReportTime());
        collectLineReportDao.saveEntity(collectLineReport);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveQualityReport(CollectLineReportQualitySaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        CollectLineReport collectLineReport = new CollectLineReport();
        collectLineReport.setUserNo(userNo);
        collectLineReport.setName(loginUserInfo.getUserName());
        collectLineReport.setMobile(loginUserInfo.getUserMobile());
        collectLineReport.setTruckNo(orderChild.getTruckNo());

        collectLineReport.setChildNo(param.getChildNo());
        collectLineReport.setSendAddressId(orderChild.getSendAddressId());
        collectLineReport.setSendAddress(orderChild.getSendAddress());
        collectLineReport.setReceiveAddressId(orderChild.getReceiveAddressId());
        collectLineReport.setReceiveAddress(orderChild.getReceiveAddress());

        collectLineReport.setType(CollectLineReport.Type.RECEIVE.getCode());
        collectLineReport.setReportType(CollectLineReport.ReportType.QUALITY.getCode());

        collectLineReport.setReportStatus(CollectLineReport.ReportStatus.NORMAL.getCode());
        collectLineReport.setRemark(param.getRemark());
        collectLineReport.setImage(param.getImageList()==null? null:JSON.toJSONString(param.getImageList()));
        collectLineReport.setReportTime(LocalDateTime.now());
        collectLineReport.setCreateTime(collectLineReport.getReportTime());
        collectLineReportDao.saveEntity(collectLineReport);

    }

    @Override
    public CollectLineReportVO getReportInfo(Integer id) {
        return collectLineReportDao.getEntityByKey(id).map(collectLineReportStruct::convert).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

    }

    @Override
    public IPage<CollectLineReportVO> pageLineReport(PageCollectLineReportParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        param.setUserNo(userNo);
        return collectLineReportDao.pageLineReport(param);
    }

    @Override
    public IPage<CollectLineReportVO> carrierPageSendAddressReport(CarrierPageCollectSendAddressReportParam param) {
        return collectLineReportDao.carrierPageSendAddressReport(param);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateSendAddressReportAudit(CollectLineReportSendAddressAuditParam param) {
        CollectLineReport collectLineReport = collectLineReportDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        collectLineReport.setAuditStatus(CollectLineReport.AuditStatus.AUDIT.getCode());
        collectLineReportDao.updateAuditStatus(collectLineReport);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateAbnormalReportAudit(CollectLineReportSendAddressAuditParam param) {
        CollectLineReport collectLineReport = collectLineReportDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        collectLineReport.setAuditStatus(CollectLineReport.AuditStatus.AUDIT.getCode());
        collectLineReportDao.updateAuditStatus(collectLineReport);

        // 查找规则
        AppIntegralRuleVO ruleInfo = integralRuleService.getRuleInfo();
        // 报存积分
        integralRecordService.addDriverReportRecord(ruleInfo, collectLineReport.getTruckNo(), IntegralRecordEnum.Type.REPORT_ABNORMAL.getValue(),
                ruleInfo.getDriverReportRule().getIntegralQuality(), IntegralRecordEnum.Type.REPORT_ABNORMAL.getMsg());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateNoTakeOrderReportAudit(CollectLineReportSendAddressAuditParam param) {
        CollectLineReport collectLineReport = collectLineReportDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        collectLineReport.setAuditStatus(CollectLineReport.AuditStatus.AUDIT.getCode());
        collectLineReportDao.updateAuditStatus(collectLineReport);

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateQualityReportAudit(CollectLineReportSendAddressAuditParam param) {
        CollectLineReport collectLineReport = collectLineReportDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        collectLineReport.setAuditStatus(CollectLineReport.AuditStatus.AUDIT.getCode());
        collectLineReportDao.updateAuditStatus(collectLineReport);

        // 查找规则
        AppIntegralRuleVO ruleInfo = integralRuleService.getRuleInfo();

        // 报存积分
        integralRecordService.addDriverReportRecord(ruleInfo, collectLineReport.getTruckNo(), IntegralRecordEnum.Type.REPORT_QUALITY.getValue(),
                ruleInfo.getDriverReportRule().getIntegralQuality(), IntegralRecordEnum.Type.REPORT_QUALITY.getMsg());
    }

    @Override
    public IPage<CollectLineReportVO> carrierPageAbnormalReport(CarrierPageCollectAbnormalReportParam param) {
        return collectLineReportDao.carrierPageAbnormalReport(param);
    }

    @Override
    public IPage<CollectLineReportVO> carrierPageNoTakeOrderReport(CarrierPageCollectNoTakeOrderReportParam param) {
        return collectLineReportDao.carrierPageNoTakeOrderReport(param);

    }

    @Override
    public IPage<CollectLineReportVO> carrierPageQualityReport(CarrierPageCollectQualityReportParam param) {
        return collectLineReportDao.carrierPageQualityReport(param);
    }

    @Override
    public IPage<CollectLineReportVO> carrierPageOtherReport(CarrierPageCollectOtherReportParam param) {
        return collectLineReportDao.carrierPageOtherReport(param);

    }

}
