package com.clx.performance.config;

import com.github.xiaoymin.knife4j.spring.annotations.EnableKnife4j;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ParameterType;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.util.ArrayList;
import java.util.List;

@Profile({"dev", "test", "release"})
@Configuration
@EnableSwagger2
@EnableKnife4j
public class Knife4jConfig {
    @Value("${spring.application.name}")
    private String appName;

    @Bean
    public Docket createRestApi() {
        List<RequestParameter> requestParameters = new ArrayList<>();
        requestParameters.add(new RequestParameterBuilder()
                .name("token")
                .description("用户登录凭证(token)")
                .in(ParameterType.HEADER)
                .query(parameterSpecificationBuilder -> parameterSpecificationBuilder.defaultValue("143215321432151234")
                        .allowEmptyValue(false))
                .required(true)
                .build());
        requestParameters.add(new RequestParameterBuilder()
                .name("product-code")
                .description("产品code")
                .in(ParameterType.HEADER)
                .query(parameterSpecificationBuilder -> parameterSpecificationBuilder.defaultValue("msl-quality")
                        .allowEmptyValue(false))
                .required(true)
                .build());
        Docket docker = new Docket(DocumentationType.SWAGGER_2)
                .forCodeGeneration(true)
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class))
                .paths(PathSelectors.any())
                .build();
        docker.globalRequestParameters(requestParameters);
        return docker;
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                .title("诚联信承运用户说明文档")
                .description("<div style='font-size=14px;color:red'>诚联信承运用户接口说明</div>")
                .termsOfServiceUrl("http://api.clx.cn")
                .version("1.0")
                .build();
    }
}
