package com.clx.performance.sqlProvider.breakcontract;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.app.breakcontract.DriverPageBreakContractDriverRecordParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractDriverRecordParam;
import com.clx.performance.vo.app.breakcontract.DriverBreakContractDriverRecordVO;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractDriverRecordVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class BreakContractDriverRecordSqlProvider {

    public String pageByParam(@Param("page") Page<BreakContractDriverRecordVO> page, @Param("param") PageBreakContractDriverRecordParam param) {
        return new SQL(){{

            SELECT(" id, trigger_type, break_contract_party_type, break_no, " +
                    " child_no, truck_no, truck_own_user_no, truck_own_name, " +
                    " driver_user_no, driver_name, figure, time_limit, " +
                    " date_format(limit_time, '%Y-%m-%d %H:%i:%s') as limitTime, " +
                    " settlement_no, " +
                    " remark, " +
                    " create_by, create_name, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );

            FROM("break_contract_driver_record");

            if (StringUtils.isNotBlank(param.getChildNo())) {WHERE("child_no = #{param.childNo}");}
            if (Objects.nonNull(param.getTriggerType())) {WHERE("trigger_type = #{param.triggerType}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

    public String driverPageByParam(@Param("page") Page<DriverBreakContractDriverRecordVO> page, @Param("param") DriverPageBreakContractDriverRecordParam param) {
        return new SQL(){{

            SELECT(" id, trigger_type, break_contract_party_type, break_no, " +
                    " child_no, truck_no, truck_own_user_no, truck_own_name, " +
                    " driver_user_no, driver_name, figure, time_limit, " +
                    " date_format(limit_time, '%Y-%m-%d %H:%i:%s') as limitTime, " +
                    " settlement_no, " +
                    " remark, " +
                    " create_by, create_name, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );

            FROM("break_contract_driver_record");
            WHERE("(truck_own_user_no = #{param.userNo} or driver_user_no = #{param.userNo})");
            if (Objects.equals(param.getType(), 1)) {WHERE("break_contract_party_type = 3");}
            if (Objects.equals(param.getType(), 2)) {WHERE("break_contract_party_type = 1");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

}
