package com.clx.performance.service.impl.breakcontract;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.breakcontract.BreakContractSettlementLogDao;
import com.clx.performance.dao.breakcontract.BreakContractSettlementOwnerDao;
import com.clx.performance.enums.*;
import com.clx.performance.model.breakcontract.BreakContractSettlementLog;
import com.clx.performance.model.breakcontract.BreakContractSettlementOwner;
import com.clx.performance.param.pc.breakcontract.carrier.*;
import com.clx.performance.service.breakcontract.BreakContractSettlementLogService;
import com.clx.performance.service.breakcontract.BreakContractSettlementOwnerService;
import com.clx.performance.struct.breakcontract.BreakContractSettlementLogStruct;
import com.clx.performance.struct.breakcontract.BreakContractSettlementOwnerStruct;
import com.clx.performance.utils.excel.ExcelData;
import com.clx.performance.utils.excel.ExcelField;
import com.clx.performance.utils.excel.ExcelSheet;
import com.clx.performance.utils.excel.ExcelUtil;
import com.clx.performance.vo.pc.breakcontract.carrier.CarrierBreakContractSettlementLogVO;
import com.clx.performance.vo.pc.breakcontract.carrier.CarrierBreakContractSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerVO;
import com.msl.common.exception.ServiceSystemException;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Service
@Slf4j
@AllArgsConstructor
public class BreakContractSettlementOwnerServiceImpl  implements BreakContractSettlementOwnerService {

    private final BreakContractSettlementOwnerDao breakContractSettlementOwnerDao;
    private final BreakContractSettlementOwnerStruct breakContractSettlementOwnerStruct;
    private final BreakContractSettlementLogDao breakContractSettlementLogDao;
    private final BreakContractSettlementLogStruct breakContractSettlementLogStruct;
    private final BreakContractSettlementLogService breakContractSettlementLogService;
    

    @Override
    public IPage<PageCarrierBreakContractSettlementOwnerVO> pageCarrierBreakContractSettlementOwnerList(PageCarrierBreakContractSettlementOwnerParam param) {
        IPage<BreakContractSettlementOwner> breakContractSettlementDriverDetail = breakContractSettlementOwnerDao.pageCarrierBreakContractSettlementOwnerList(param);
        List<PageCarrierBreakContractSettlementOwnerVO> list = breakContractSettlementOwnerStruct.covertToCarrierList(breakContractSettlementDriverDetail.getRecords());
        return new Page<PageCarrierBreakContractSettlementOwnerVO>().setRecords(list).setTotal(breakContractSettlementDriverDetail.getTotal()).setPages(breakContractSettlementDriverDetail.getPages());

    }

    @Override
    public SXSSFWorkbook exportCarrierBreakContractSettlementOwnerList(PageCarrierBreakContractSettlementOwnerParam param) {
        param.setPage(1);
        param.setPageSize(1000000);
        IPage<PageCarrierBreakContractSettlementOwnerVO> settlementOwnerDetail = pageCarrierBreakContractSettlementOwnerList(param);

        List<PageCarrierBreakContractSettlementOwnerVO> list = settlementOwnerDetail.getRecords();

        // 组装表头
        List<ExcelField> fieldList = new ArrayList<>();
        fieldList.add(new ExcelField(0, "序号", "index", 2000));
        fieldList.add(new ExcelField(1, "订单编号", "orderNo", 5000));
        fieldList.add(new ExcelField(2, "货主编号", "ownUserNo", 5000));
        fieldList.add(new ExcelField(3, "货主名称", "ownerName", 5000));

        fieldList.add(new ExcelField(4, "违约方", "breakContractPartyType", 5000));
        fieldList.add(new ExcelField(5, "违约金额", "figure", 5000));
        fieldList.add(new ExcelField(6, "状态", "statusMsg", 5000));
        fieldList.add(new ExcelField(7, "结算单号", "settlementNo", 5000));
        fieldList.add(new ExcelField(8, "创建人", "createName", 5000));
        fieldList.add(new ExcelField(9, "创建时间", "createTime", 5000));



        // 组装数据
        List<List<ExcelData>> dataList = new ArrayList<>();
        for (int i=0; i<list.size(); i++){

            PageCarrierBreakContractSettlementOwnerVO dto = list.get(i);
            List<ExcelData> rowData = new ArrayList<>();

            rowData.add(new ExcelData(i+1));
            rowData.add(new ExcelData(dto.getOrderNo()));
            rowData.add(new ExcelData(dto.getOwnerUserNo()+""));
            rowData.add(new ExcelData(dto.getOwnerName()));

            rowData.add(new ExcelData(dto.getBreakContractPartyTypeMsg()));
            rowData.add(new ExcelData(dto.getFigure().movePointLeft(2)));
            rowData.add(new ExcelData(dto.getStatusMsg()));
            rowData.add(new ExcelData(dto.getSettlementNo()));
            rowData.add(new ExcelData(dto.getCreateName()));
            rowData.add(new ExcelData(dto.getCreateTime()));


            dataList.add(rowData);
        }

        ExcelSheet excelSheet = new ExcelSheet("货主违约结算单", "货主违约结算单", fieldList, dataList);

        //创建excel
        return ExcelUtil.create(excelSheet);
    }

    @Override
    public CarrierBreakContractSettlementOwnerDetailVO getCarrierBreakContractSettlementOwnerDetail(Integer id) {
        //结算单详情
        BreakContractSettlementOwner settlementOwner =breakContractSettlementOwnerDao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        CarrierBreakContractSettlementOwnerDetailVO detail = breakContractSettlementOwnerStruct.convertToDetail(settlementOwner);

        String settlementNo = settlementOwner.getSettlementNo();
        List<BreakContractSettlementLog> settlementLogs = breakContractSettlementLogDao.getSettlementLogs(settlementNo);

        List<CarrierBreakContractSettlementLogVO> settlementLogVOS = breakContractSettlementLogStruct.covertToCarrierList(settlementLogs);
        detail.setLogs(settlementLogVOS);
        return detail;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void uploadInvoiceImg(CarrierUploadInvoiceImgParam param) {

        BreakContractSettlementOwner settlementOwner = breakContractSettlementOwnerDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        if(!Objects.equals(settlementOwner.getStatus(), BreakContractSettlementOwnerEnum.Status.TO_BE_LOCKED.getCode())){
            throw new ServiceSystemException(PerformanceResultEnum.STATUS_CHANGED);
        }
        breakContractSettlementOwnerDao.uploadInvoiceImg(param.getId(),param.getInvoiceImg());

        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        //保存结算单日志----上传结算凭证
        breakContractSettlementLogService.saveBreakSettlementLog(settlementOwner.getSettlementNo(),
                BreakContractSettlementLogEnum.Type.UPLOAD_SETTLEMENT.getCode(),BreakContractSettlementLogEnum.Type.UPLOAD_SETTLEMENT.getMsg(),
                OrderChildLogEnum.CreateType.PLATFORM.getCode(),loginUserInfo.getUserNo(),loginUserInfo.getUserName());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCancelSettlement(CarrierCancelSettlementParam param) {
        BreakContractSettlementOwner settlementOwner = breakContractSettlementOwnerDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        if(!Objects.equals(settlementOwner.getStatus(), BreakContractSettlementOwnerEnum.Status.TO_BE_LOCKED.getCode())){
            throw new ServiceSystemException(PerformanceResultEnum.STATUS_CHANGED);
        }

        breakContractSettlementOwnerDao.updateStatus(param.getId(),BreakContractSettlementOwnerEnum.Status.TO_BE_LOCKED.getCode(),BreakContractSettlementOwnerEnum.Status.CANCEL.getCode());

        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        //保存结算单日志----取消结算单
        breakContractSettlementLogService.saveBreakSettlementLog(settlementOwner.getSettlementNo(),
                BreakContractSettlementLogEnum.Type.CANCEL.getCode(),BreakContractSettlementLogEnum.Type.CANCEL.getMsg(),
                OrderChildLogEnum.CreateType.PLATFORM.getCode(),loginUserInfo.getUserNo(),loginUserInfo.getUserName());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveCarrierBreakContractPayee(CarrierBreakContractSavePayeeParam param) {
        BreakContractSettlementOwner settlementOwner = breakContractSettlementOwnerDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        if(!Objects.equals(settlementOwner.getStatus(), BreakContractSettlementOwnerEnum.Status.PLATFORM_TO_PAYMENT.getCode())){
            throw new ServiceSystemException(PerformanceResultEnum.STATUS_CHANGED);
        }

        param.setStatus(BreakContractSettlementOwnerEnum.Status.OWNER_CONFIRMED_PLATFORM_PAYMENT.getCode());
        breakContractSettlementOwnerDao.saveCarrierBreakContractPayee(param);

        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        //保存结算单日志----平台付款
        breakContractSettlementLogService.saveBreakSettlementLog(settlementOwner.getSettlementNo(),
                BreakContractSettlementLogEnum.Type.PLATFORM_TO_PAYMENT.getCode(),BreakContractSettlementLogEnum.Type.PLATFORM_TO_PAYMENT.getMsg(),
                OrderChildLogEnum.CreateType.PLATFORM.getCode(),loginUserInfo.getUserNo(),loginUserInfo.getUserName());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCarrierBreakContractPayeeConfirm(CarrierBreakPayeeConfirmParam param) {
        BreakContractSettlementOwner settlementOwner = breakContractSettlementOwnerDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        if(!Objects.equals(settlementOwner.getStatus(), BreakContractSettlementOwnerEnum.Status.PLATFORM_CONFIRMED_OWNER_PAYMENT.getCode())){
            throw new ServiceSystemException(PerformanceResultEnum.STATUS_CHANGED);
        }

        breakContractSettlementOwnerDao.updateStatus(param.getId(),BreakContractSettlementOwnerEnum.Status.PLATFORM_CONFIRMED_OWNER_PAYMENT.getCode(),BreakContractSettlementOwnerEnum.Status.COMPLETED.getCode());


        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        //保存结算单日志----平台确认付款
        breakContractSettlementLogService.saveBreakSettlementLog(settlementOwner.getSettlementNo(),
                BreakContractSettlementLogEnum.Type.PLATFORM_CONFIRMED_OWNER_PAYMENT.getCode(),BreakContractSettlementLogEnum.Type.PLATFORM_CONFIRMED_OWNER_PAYMENT.getMsg(),
                OrderChildLogEnum.CreateType.PLATFORM.getCode(),loginUserInfo.getUserNo(),loginUserInfo.getUserName());

        //保存结算单日志----已完结
        breakContractSettlementLogService.saveBreakSettlementLog(settlementOwner.getSettlementNo(),
                BreakContractSettlementLogEnum.Type.COMPLETED.getCode(),BreakContractSettlementLogEnum.Type.COMPLETED.getMsg(),
                OrderChildLogEnum.CreateType.PLATFORM.getCode(),loginUserInfo.getUserNo(),loginUserInfo.getUserName());
    }

    @Override
    public void updateConfirmSettlement(OwnerConfirmSettlementParam param) {
        BreakContractSettlementOwner settlementOwner = breakContractSettlementOwnerDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        if(!Objects.equals(settlementOwner.getStatus(), BreakContractSettlementOwnerEnum.Status.OWNER_TO_BE_CONFIRMED.getCode())){
            throw new ServiceSystemException(PerformanceResultEnum.STATUS_CHANGED);
        }

        int status = BreakContractSettlementOwnerEnum.Status.SHIPPER_TO_PAYMENT.getCode();
        if(Objects.equals(settlementOwner.getBreakContractPartyType(), BreakContractSettlementDriverEnum.BreakContractPartyType.PLATFORM.getCode())){
            status = BreakContractSettlementOwnerEnum.Status.PLATFORM_TO_PAYMENT.getCode();
        }
        breakContractSettlementOwnerDao.updateStatus(param.getId(),BreakContractSettlementOwnerEnum.Status.OWNER_TO_BE_CONFIRMED.getCode(),status);

        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        //保存结算单日志----确认结算单
        breakContractSettlementLogService.saveBreakSettlementLog(settlementOwner.getSettlementNo(),
                BreakContractSettlementLogEnum.Type.OWNER_TO_BE_CONFIRMED.getCode(),BreakContractSettlementLogEnum.Type.OWNER_TO_BE_CONFIRMED.getMsg(),
                OrderChildLogEnum.CreateType.PLATFORM.getCode(),loginUserInfo.getUserNo(),loginUserInfo.getUserName());
    }

    @Override
    public void saveOwnerBreakContractPayee(CarrierBreakContractSavePayeeParam param) {
        BreakContractSettlementOwner settlementOwner = breakContractSettlementOwnerDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        if(!Objects.equals(settlementOwner.getStatus(), BreakContractSettlementOwnerEnum.Status.SHIPPER_TO_PAYMENT.getCode())){
            throw new ServiceSystemException(PerformanceResultEnum.STATUS_CHANGED);
        }

        param.setStatus(BreakContractSettlementOwnerEnum.Status.PLATFORM_CONFIRMED_OWNER_PAYMENT.getCode());
        breakContractSettlementOwnerDao.saveCarrierBreakContractPayee(param);

        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        //保存结算单日志----货主付款
        breakContractSettlementLogService.saveBreakSettlementLog(settlementOwner.getSettlementNo(),
                BreakContractSettlementLogEnum.Type.SHIPPER_TO_PAYMENT.getCode(),BreakContractSettlementLogEnum.Type.SHIPPER_TO_PAYMENT.getMsg(),
                OrderChildLogEnum.CreateType.PLATFORM.getCode(),loginUserInfo.getUserNo(),loginUserInfo.getUserName());
    }

    @Override
    public void updateOwnerBreakContractPayeeConfirm(CarrierBreakPayeeConfirmParam param) {
        BreakContractSettlementOwner settlementOwner = breakContractSettlementOwnerDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        if(!Objects.equals(settlementOwner.getStatus(), BreakContractSettlementOwnerEnum.Status.OWNER_CONFIRMED_PLATFORM_PAYMENT.getCode())){
            throw new ServiceSystemException(PerformanceResultEnum.STATUS_CHANGED);
        }

        breakContractSettlementOwnerDao.updateStatus(param.getId(),BreakContractSettlementOwnerEnum.Status.OWNER_CONFIRMED_PLATFORM_PAYMENT.getCode(),BreakContractSettlementOwnerEnum.Status.COMPLETED.getCode());


        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        //保存结算单日志----货主确认付款
        breakContractSettlementLogService.saveBreakSettlementLog(settlementOwner.getSettlementNo(),
                BreakContractSettlementLogEnum.Type.OWNER_CONFIRMED_PLATFORM_PAYMENT.getCode(),BreakContractSettlementLogEnum.Type.OWNER_CONFIRMED_PLATFORM_PAYMENT.getMsg(),
                OrderChildLogEnum.CreateType.PLATFORM.getCode(),loginUserInfo.getUserNo(),loginUserInfo.getUserName());

        //保存结算单日志----已完结
        breakContractSettlementLogService.saveBreakSettlementLog(settlementOwner.getSettlementNo(),
                BreakContractSettlementLogEnum.Type.COMPLETED.getCode(),BreakContractSettlementLogEnum.Type.COMPLETED.getMsg(),
                OrderChildLogEnum.CreateType.PLATFORM.getCode(),loginUserInfo.getUserNo(),loginUserInfo.getUserName());
    }
}
