package com.clx.performance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.order.enums.VehicleUsageEnum;
import com.clx.order.feign.OrderFeign;
import com.clx.order.param.feign.RollbackOrderWeightParam;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dao.OrderGoodsDriverTruckDao;
import com.clx.performance.dao.OrderGoodsTruckBindDao;
import com.clx.performance.enums.*;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.OrderGoodsDriverTruck;
import com.clx.performance.model.OrderGoodsTruckBind;
import com.clx.performance.param.app.OrderGoodsListPageParam;
import com.clx.performance.param.pc.OrderGoodsCancelParam;
import com.clx.performance.param.pc.UpdateEditOrderGoodsParam;
import com.clx.performance.param.pc.UpdateOrderGoodsPriceParam;
import com.clx.performance.service.OrderGoodsLogService;
import com.clx.performance.service.OrderGoodsService;
import com.clx.performance.struct.OrderGoodsStruct;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.performance.vo.feign.OrderGoodsFeignVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.clx.user.feign.UserClxFeign;
import com.msl.common.base.Optional;
import com.msl.common.enums.ResultCodeEnum;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Service
@Slf4j
@AllArgsConstructor
public class OrderGoodsServiceImpl implements OrderGoodsService {


    private OrderGoodsDao orderGoodsDao;


    private OrderGoodsStruct orderGoodsStruct;


    private OrderFeign orderFeign;


    private OrderGoodsTruckBindDao orderGoodsTruckBindDao;


    private OrderGoodsDriverTruckDao orderGoodsDriverTruckDao;

    private OrderGoodsLogService orderGoodsLogService;


    private UserClxFeign userClxFeign;


    private OrderChildDao orderChildDao;

    @Override
    public OrderGoodsVO getOrderGoodsInfoByOrderGoodsNoForPC(String orderGoodsNo) {
        OrderGoodsVO orderGoodsVO = orderGoodsDao.getOrderGoodsInfoByOrderGoodsNoForPC(orderGoodsNo).map(orderGoodsStruct::convert).get();
        List<String> truckList = orderGoodsTruckBindDao.selectListByOrderGoodsNo(orderGoodsNo).stream().map(OrderGoodsTruckBind::getTruckNo).collect(Collectors.toList());
        String orderNo = orderGoodsVO.getOrderNo();
        orderGoodsVO.setTruckList(truckList);
        FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(orderNo);
        orderGoodsVO.setReveiveAddressAll(orderInfoFeign.getReveiveAddressAll());
        orderGoodsVO.setSendAddressAll(orderInfoFeign.getSendAddressAll());
        return orderGoodsVO;
    }

    @Override
    public OrderGoodsVO getOrderGoodsInfoByOrderGoodsNoForAPP(String orderGoodsNo) {
        OrderGoodsVO orderGoodsVO = orderGoodsDao.getOrderGoodsInfoByOrderGoodsNoForAPP(orderGoodsNo).map(orderGoodsStruct::convert).get();
        String orderNo = orderGoodsVO.getOrderNo();
        FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(orderNo);
        orderGoodsVO.setReveiveAddressAll(orderInfoFeign.getReveiveAddressAll());
        orderGoodsVO.setSendAddressAll(orderInfoFeign.getSendAddressAll());
        orderGoodsVO.setResidueTransportWeight(BigDecimal.ZERO.compareTo(orderGoodsVO.getResidueTransportWeight()) > 0 ? BigDecimal.ZERO : orderGoodsVO.getResidueTransportWeight());
        return orderGoodsVO;
    }

    @Override
    public IPage<OrderGoodsVO> pageOrderGoodsList(PageOrderGoodsListParam param) {
        return orderGoodsDao.pageOrderGoodsList(param);
    }

    @Override
    public void updateOrderGoodsReduceWeightAndStatus(Integer id, BigDecimal orderChildWeight, Integer orderGoodsStatus) {
        orderGoodsDao.updateOrderGoodsReduceWeightAndStatus(id, orderChildWeight, orderGoodsStatus);
    }

    @Override
    public void updateOrderGoodsReduceWeightAndStatus(OrderGoods orderGoods, BigDecimal orderChildWeight, Integer orderGoodsStatus) {
        orderGoodsDao.updateOrderGoodsReduceWeightAndStatus(orderGoods.getId(), orderChildWeight, orderGoodsStatus);
        if (orderGoods.getResidueTransportWeight().compareTo(orderChildWeight) <= 0) {
            orderGoodsTruckBindDao.updateOrderGoodsBindStatusExpire(orderGoods.getOrderGoodsNo());
        }

    }

    @Override
    public IPage<OrderGoodsAPPVO> indexOrderGoodsList(OrderGoodsListPageParam orderGoodsListParam) {
        if (StringUtils.equals(orderGoodsListParam.getOrderGoodsType(), "1")) {
            return orderGoodsDao.openOrderPageGoodsList(orderGoodsListParam);
        } else {
            Optional<List<OrderGoodsDriverTruck>> truckList = orderGoodsDriverTruckDao.
                    selectListByDriverUserNo(orderGoodsListParam.getDriverUserNo());

            List<String> truckNoList = new ArrayList<>();

            //查询当前用户是否是货主
            Long driverUserNo = orderGoodsListParam.getDriverUserNo();
            Result<List<String>> ownTruckByUserNo = userClxFeign.getOwnTruckByUserNo(driverUserNo);
            log.info("通过用户编号:{} 查询本人车辆，查询结果:{}", driverUserNo, JSON.toJSONString(ownTruckByUserNo));
            if (Objects.equals(ownTruckByUserNo.getCode(), ResultCodeEnum.SUCCESS.getCode())) {
                if ((!truckList.isPresent() || CollectionUtils.isEmpty(truckList.get())) && ownTruckByUserNo.getData().isEmpty()) {
                    log.warn("用户编号:{},当前用户未绑定车辆", driverUserNo);
                    return new Page<>();
                }
                truckNoList.addAll(ownTruckByUserNo.getData());//当前用户自己的车
                truckNoList.addAll(truckList.get().stream().map(OrderGoodsDriverTruck::getTruckNo).collect(Collectors.toList()));//当前用户被绑定为司机的车
            }
            if (CollectionUtils.isEmpty(truckNoList)) {
                log.warn("用户编号:{},查询车主车辆和作为司机的车辆全未查询到数据", driverUserNo);
                return new Page<>();
            }
            Optional<List<OrderGoodsTruckBind>> orderGoodsDriverTrucks = orderGoodsTruckBindDao.selectListByTruckNo(
                    truckNoList);
            if (!orderGoodsDriverTrucks.isPresent() || orderGoodsDriverTrucks.get().isEmpty()) {
                log.warn("用户编号:{},无专属单", driverUserNo);
                return new Page<>();
            }

            List<String> orderGoodsNoList = orderGoodsDriverTrucks.get().stream().map(OrderGoodsTruckBind::getOrderGoodsNo).collect(Collectors.toList());
            return orderGoodsDao.exclusiveOrderPageGoodsList(orderGoodsListParam, orderGoodsNoList);
        }
    }

    @Override
    public List<OrderGoodsFeignVO> getOrderGoodsListByOrderNo(String orderNo) {
        List<OrderGoods> list = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);
        return orderGoodsStruct.convertList(list);
    }

    @Override
    public List<OrderGoods> getOrderGoodsList(String orderNo, LocalDateTime lastArriveSendTime) {
        return orderGoodsDao.getOrderGoodsListByOrderNoAndLastArriveSendTime(orderNo, lastArriveSendTime);
    }

    @Override
    public String orderCancelStyle(String orderNo) {
        FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(orderNo);
        Integer orderStatus = orderInfoFeign.getOrderStatus();

        switch (orderStatus) {
            case 0:
                //不算违约 弹窗1
                return "writeRemark";
            case 1:
                //不算违约 弹窗1
                return "writeRemark";
            case 2:
                //算违约，但是不会有吨数，弹窗2
                return "remarkHasAmount";
            case 3:
                //算违约，但是不会有吨数，弹窗2
                return "remarkHasAmount";
            case 4:
                //已取消状态，不会涉及弹窗
            case 5:
                //暂停的订单不会在列表中展示
            case 6:
                //拒绝承运，不会在列表中展示
            case 7:
                //挂单中 ，算违约，需要判断弹窗2还是3
                //约可取消吨数
                return "selectType";
            case 8: //运输中 ，算违约， 弹窗3
                return "selectType";
            case 9:  //已完成，不能取消
            case 10: //已失效,不会出现在订单列表
            case 11: //已挂单  算违约  弹窗 2
                return "remarkHasAmount";
            case 12: //已完结
            default:
                throw new RuntimeException();
        }
    }

    @Override
    public BigDecimal orderCancelResidueWeight(String orderNo, String optionType) {
        FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(orderNo);

        if (StringUtils.equals(optionType, "1")) {
            return new BigDecimal(orderInfoFeign.getResidueWeight());
        } else {
            String residueWeight = orderInfoFeign.getResidueWeight();
            List<OrderChild> orderChildList = orderChildDao.selectResidueWeight(orderNo, OrderChildEnum.Status.ARRIVE_SEND.getCode());
            BigDecimal childResidueWeight = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(orderChildList)) {
                childResidueWeight = orderChildList.stream().map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);

            }
            BigDecimal orderGoodsResidueWeight = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo).stream().map(OrderGoods::getResidueTransportWeight).reduce(BigDecimal.ZERO,BigDecimal::add);

            return new BigDecimal(residueWeight).add(orderGoodsResidueWeight).add(childResidueWeight);
        }

    }


    @Override
    public void updateEditOrderGoods(UpdateEditOrderGoodsParam param) {

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateOrderGoodsPrice(UpdateOrderGoodsPriceParam param) {
        OrderGoods orderGoods = orderGoodsDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        BigDecimal oldPendingOrderFreight = orderGoods.getPendingOrderFreight().divide(new BigDecimal("100"));
        orderGoodsDao.updatePendingOrderFreightById(param.getId(), param.getPendingOrderFreight());
        BigDecimal newPendingOrderFreight = param.getPendingOrderFreight().divide(new BigDecimal("100"));
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        //记录货单调价日志
        orderGoodsLogService.saveLog(orderGoods.getOrderGoodsNo(), loginUserInfo.getUserNo(), loginUserInfo.getUserName(),
                OrderGoodsLogsEnum.Type.ADJUST_PRICE.getName(), String.format("调价前%s元,调价后%s元", oldPendingOrderFreight, newPendingOrderFreight));
    }

    @Override
    public Boolean updateOrderGoodsStopFlag(String orderNo, Integer stopFlag) {
        return orderGoodsDao.updateStopFlagByOrderNo(orderNo, stopFlag);
    }

    @Override
    public String orderGoodsCancelStyle(String orderGoodsNo) {
        List<OrderChild> orderChildren = orderChildDao.selectListByOrderGoodsNo(orderGoodsNo);
        if (CollectionUtils.isNotEmpty(orderChildren)) {
            return "selectTruck";
        } else {
            return "onlyRemark";
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void orderGoodsCancel(OrderGoodsCancelParam goodsCancelParam) {
        String orderGoodsNo = goodsCancelParam.getOrderGoodsNo();
        Optional<OrderGoods> optional = orderGoodsDao.getByOrderGoodsNo(orderGoodsNo);
        if (!optional.isPresent()) {
            return;
        }
        OrderGoods orderGoods = optional.get();
        List<OrderChild> orderChildList = null;
        BigDecimal residueWeight = null;
        BigDecimal sum = BigDecimal.ZERO;
        RollbackOrderWeightParam param = new RollbackOrderWeightParam();
        Integer cancelOperateType = goodsCancelParam.getCancelOperateType();
        switch (cancelOperateType){
            case 1:
                orderChildList = orderChildDao.selectResidueWeightByOrderGoodsNo(orderGoods.getOrderGoodsNo(), null);
                if (CollectionUtils.isNotEmpty(orderChildList)) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前货单已产生运单");
                }

                residueWeight = orderGoods.getResidueTransportWeight();
                param.setResidueWeight(residueWeight);
                param.setOrderNo(orderGoods.getOrderNo());
                if (!orderGoods.getTruckDemand().equals(TruckDemandEnum.TruckType.PLATFORM_ANY_CAR.getCode())) {
                    param.setOwnResidueCarryWeight(BigDecimal.ZERO);
                    param.setPlatformResidueCarryWeight(BigDecimal.ZERO);
                } else {
                    if (orderGoods.getVehicleUsage().equals(VehicleUsageEnum.Status.PLATFORM.getCode())) {
                        param.setOwnResidueCarryWeight(BigDecimal.ZERO);
                        param.setPlatformResidueCarryWeight(residueWeight);
                    } else if (orderGoods.getVehicleUsage().equals(VehicleUsageEnum.Status.OWN.getCode())) {
                        param.setOwnResidueCarryWeight(residueWeight);
                        param.setPlatformResidueCarryWeight(BigDecimal.ZERO);
                    }
                }
                orderGoodsTruckBindDao.updateOrderGoodsBindStatus(orderGoodsNo, OrderGoodsTruckBindEnum.Status.CANCEL.getCode());

                log.info("取消货单,参数：{}", JSONUtil.parse(param));
                if (orderFeign.rollbackOrderWeight(param).succeed()) {
                    OrderGoods update = new OrderGoods();
                    update.setId(orderGoods.getId());
                    update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                    update.setResidueTransportWeight(BigDecimal.ZERO);
                    orderGoodsDao.updateEntityByKey(update);
                }
                return;
            case 2:
                orderChildList = orderChildDao.selectResidueWeightByOrderGoodsNo(orderGoods.getOrderGoodsNo(), OrderChildEnum.Status.ARRIVE_SEND.getCode());
                if (CollectionUtils.isNotEmpty(orderChildList)) {
                    sum = orderChildList.stream().map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                residueWeight = orderGoods.getResidueTransportWeight().add(sum);
                param.setResidueWeight(residueWeight);
                param.setOrderNo(orderGoods.getOrderNo());
                if (!orderGoods.getTruckDemand().equals(TruckDemandEnum.TruckType.PLATFORM_ANY_CAR.getCode())) {
                    param.setOwnResidueCarryWeight(BigDecimal.ZERO);
                    param.setPlatformResidueCarryWeight(BigDecimal.ZERO);
                } else {
                    if (orderGoods.getVehicleUsage().equals(VehicleUsageEnum.Status.PLATFORM.getCode())) {
                        param.setOwnResidueCarryWeight(BigDecimal.ZERO);
                        param.setPlatformResidueCarryWeight(residueWeight);
                    } else if (orderGoods.getVehicleUsage().equals(VehicleUsageEnum.Status.OWN.getCode())) {
                        param.setOwnResidueCarryWeight(residueWeight);
                        param.setPlatformResidueCarryWeight(BigDecimal.ZERO);
                    }
                }

                orderGoodsTruckBindDao.updateOrderGoodsBindStatus(orderGoodsNo, OrderGoodsTruckBindEnum.Status.CANCEL.getCode());
                orderChildDao.batchUpdateOrderChildStatus(OrderChildEnum.Status.PLATFORM_CANCEL.getCode(), orderChildList.stream().map(OrderChild::getId).collect(Collectors.toList()));
                log.info("取消货单,参数：{}", JSONUtil.parse(param));
                if (orderFeign.rollbackOrderWeight(param).succeed()) {
                    OrderGoods update = new OrderGoods();
                    update.setId(orderGoods.getId());
                    update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                    update.setResidueTransportWeight(BigDecimal.ZERO);
                    orderGoodsDao.updateEntityByKey(update);
                }
                return;
            case 3:
                orderChildList = orderChildDao.selectResidueWeightByOrderGoodsNo(orderGoods.getOrderGoodsNo(), OrderChildEnum.Status.LOAD.getCode(), goodsCancelParam.getTruckList());
                if (CollectionUtils.isNotEmpty(orderChildList)) {
                    sum = orderChildList.stream().map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                residueWeight = orderGoods.getResidueTransportWeight().add(sum);
                param.setResidueWeight(residueWeight);
                param.setOrderNo(orderGoods.getOrderNo());
                if (!orderGoods.getTruckDemand().equals(TruckDemandEnum.TruckType.PLATFORM_ANY_CAR.getCode())) {
                    param.setOwnResidueCarryWeight(BigDecimal.ZERO);
                    param.setPlatformResidueCarryWeight(BigDecimal.ZERO);
                } else {
                    if (orderGoods.getVehicleUsage().equals(VehicleUsageEnum.Status.PLATFORM.getCode())) {
                        param.setOwnResidueCarryWeight(BigDecimal.ZERO);
                        param.setPlatformResidueCarryWeight(residueWeight);
                    } else if (orderGoods.getVehicleUsage().equals(VehicleUsageEnum.Status.OWN.getCode())) {
                        param.setOwnResidueCarryWeight(residueWeight);
                        param.setPlatformResidueCarryWeight(BigDecimal.ZERO);
                    }
                }
                orderGoodsTruckBindDao.updateOrderGoodsBindStatus(orderGoodsNo, OrderGoodsTruckBindEnum.Status.CANCEL.getCode());
                orderChildDao.batchUpdateOrderChildStatus(OrderChildEnum.Status.PLATFORM_CANCEL.getCode(), orderChildList.stream().map(OrderChild::getId).collect(Collectors.toList()));
                log.info("取消货单,参数：{}", JSONUtil.parse(param));
                if (orderFeign.rollbackOrderWeight(param).succeed()) {
                    OrderGoods update = new OrderGoods();
                    update.setId(orderGoods.getId());
                    update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                    update.setResidueTransportWeight(BigDecimal.ZERO);
                    orderGoodsDao.updateEntityByKey(update);
                }
                return;
            default:
                throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "参数类型有误");

        }



    }

    @Override
    public BigDecimal orderGoodsCancelResidueWeight(OrderGoodsCancelParam goodsCancelParam) {
        String orderGoodsNo = goodsCancelParam.getOrderGoodsNo();
        Optional<OrderGoods> optional = orderGoodsDao.getByOrderGoodsNo(orderGoodsNo);
        if (!optional.isPresent()) {
            return null;
        }
        OrderGoods orderGoods = optional.get();
        List<OrderChild> orderChildList = null;
        BigDecimal residueWeight = null;
        BigDecimal sum = BigDecimal.ZERO;
        RollbackOrderWeightParam param = new RollbackOrderWeightParam();
        Integer cancelOperateType = goodsCancelParam.getCancelOperateType();
        switch (cancelOperateType){
            case 1:

            case 2:
                orderChildList = orderChildDao.selectResidueWeightByOrderGoodsNo(orderGoods.getOrderGoodsNo(), OrderChildEnum.Status.ARRIVE_SEND.getCode());
                if (CollectionUtils.isNotEmpty(orderChildList)) {
                    sum = orderChildList.stream().map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                residueWeight = orderGoods.getResidueTransportWeight().add(sum);

                return residueWeight;
            case 3:
                orderChildList = orderChildDao.selectResidueWeightByOrderGoodsNo(orderGoods.getOrderGoodsNo(), OrderChildEnum.Status.LOAD.getCode(), goodsCancelParam.getTruckList());
                if (CollectionUtils.isNotEmpty(orderChildList)) {
                    sum = orderChildList.stream().map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                residueWeight = orderGoods.getResidueTransportWeight().add(sum);

                return residueWeight;
            default:
                throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "参数类型有误");

        }



    }


    @Override
    public List<String> getOrderChildTruckList(String orderGoodsNo) {
        List<OrderChild> orderChildList = orderChildDao.selectResidueWeightByOrderGoodsNo(orderGoodsNo, OrderChildEnum.Status.LOAD.getCode());
        if (CollectionUtil.isNotEmpty(orderChildList)) {
            return orderChildList.stream().map(OrderChild::getTruckNo).collect(Collectors.toList());
        }
        return null;
    }
}
