package com.clx.performance.dto.zjxl.dts;

import com.clx.performance.enums.DtsOperationTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@Data
public class DataTransportDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 数据库名称
     */
    String databaseName;
    /**
     * 表名
     */
    String tableName;
    /**
     * 操作类型
     */
    DtsOperationTypeEnum operationType;

    /**
     * 操作记录id 非记录id
     */
    String recordID;
    /**
     * 操作时间戳
     */
    String recordTimestamp;

    /**
     * 修改之前数据
     */
    Map<String, Object> beforeMap;
    /**
     * 修改之后数据
     */
    Map<String, Object> afterMap;


}
