package com.clx.performance.dao.impl.breakcontract;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.breakcontract.BreakContractSettlementDriverDao;
import com.clx.performance.mapper.breakcontract.BreakContractSettlementDriverMapper;
import com.clx.performance.model.breakcontract.BreakContractSettlementDriver;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementDriverParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Objects;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Repository
public class BreakContractSettlementDriverDaoImpl extends BaseDaoImpl<BreakContractSettlementDriverMapper, BreakContractSettlementDriver, Integer> implements BreakContractSettlementDriverDao {
    @Override
    public IPage<BreakContractSettlementDriver> pageCarrierBreakContractSettlementDriverList(PageCarrierBreakContractSettlementDriverParam param) {

        LambdaQueryWrapper<BreakContractSettlementDriver> query = new LambdaQueryWrapper<>();
        query.eq(StringUtils.isNotBlank(param.getChildNo()),BreakContractSettlementDriver :: getChildNo,param.getChildNo());
        query.eq(StringUtils.isNotBlank(param.getTruckOwnName()),BreakContractSettlementDriver :: getTruckOwnName,param.getTruckOwnName());
        query.eq(Objects.nonNull(param.getSettleStatus()),BreakContractSettlementDriver :: getSettleStatus,param.getSettleStatus());
        query.eq(Objects.nonNull(param.getTruckOwnUserNo()),BreakContractSettlementDriver :: getTruckOwnUserNo,param.getTruckOwnUserNo());
        query.eq(Objects.nonNull(param.getBreakContractPartyType()),BreakContractSettlementDriver :: getBreakContractPartyType,param.getBreakContractPartyType());
        query.ge(StringUtils.isNotBlank(param.getBeginTime()),BreakContractSettlementDriver :: getCreateTime,param.getBeginTime());
        query.le(StringUtils.isNotBlank(param.getEndTime()),BreakContractSettlementDriver :: getCreateTime,param.getEndTime());
        query.orderByDesc(BreakContractSettlementDriver::getId);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);

    }
}
