package com.clx.performance.vo.pc.breakcontract.carrier;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.List;


@Getter
@Setter
@ToString
@NoArgsConstructor
public class CarrierBreakContractSettlementOwnerDetailVO {

    @ApiModelProperty("违约方类型：1平台 2货主 3车主")
    private Integer breakContractPartyType;

    @ApiModelProperty("违约方类型Msg：1平台 2货主 3车主")
    private String breakContractPartyTypeMsg;

    @ApiModelProperty("结算单号")
    private String settlementNo;

    @ApiModelProperty("货主用户编号")
    private Long ownerUserNo;

    @ApiModelProperty("货主名称")
    private String ownerName;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("状态msg")
    private String statusMsg;

    @ApiModelProperty("状态")
    private Integer status;

    @ApiModelProperty("违约金")
    private BigDecimal figure;

    @ApiModelProperty("操作人名称")
    private String createName;

    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("结算凭证")
    private String invoiceImg;

    @ApiModelProperty("收款人")
    private String payee;

    @ApiModelProperty("收款银行")
    private String payeeBankName;

    @ApiModelProperty("收款银行卡卡号")
    private String payeeBankCardNo;

    @ApiModelProperty("付款凭证")
    private String paymentImg;

    @ApiModelProperty("付款银行")
    private String paymentBankName;

    @ApiModelProperty("付款银行卡卡号")
    private String paymentBankCardNo;

    @ApiModelProperty("操作日志")
    private List<CarrierBreakContractSettlementLogVO> logs;


}