package com.clx.performance.param.pc.breakcontract.carrier;

import com.msl.common.base.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Setter
@Getter
@ToString
@NoArgsConstructor
public class PageCarrierBreakContractSettlementOwnerParam extends PageParam {

    @ApiModelProperty(value="货主编号",example = "201457878",hidden = true)
    private Long ownerUserNo;

    @ApiModelProperty("货主名称")
    private String ownerName;

    @ApiModelProperty(value="订单编号",example = "201457878")
    private String orderNo;

    @ApiModelProperty(value="结算单号",example = "201457878")
    private String settlementNo;

    @ApiModelProperty(value = "违约方类型：1平台 2货主 3车主", example = "1")
    private Integer breakContractPartyType;

    @ApiModelProperty(value = "状态：10-待锁定,20-待货主确认,30-待货主付款,40-待平台确认付款,50-待平台付款,60-待货主确认付款,70-已完结,80-已取消", example = "1")
    private Integer status;

    @ApiModelProperty(value="开始时间",example = "2012-01-01 00:00:00")
    private String beginTime;

    @ApiModelProperty(value="结束时间",example = "2012-01-01 00:00:00")
    private String endTime;

}
