package com.clx.performance.sqlProvider.vehiclewarn;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnRangeParam;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class VehicleWarnRangeSqlProvider {

    private static final String TABLE = "vehicle_warn_range";

    public String pageByParam(@Param("page") Page page, @Param("param") PageVehicleWarnRangeParam param) {

        return new SQL(){{

            SELECT("*");
            FROM(TABLE);
            WHERE("(status = 1 and warn_end_time > now())");
            if (StringUtils.isNotBlank(param.getWarnName())) {WHERE("warn_name like CONCAT('%', #{param.warnName},'%')");}
            if (Objects.nonNull(param.getWarnRang())) {WHERE("warn_rang = #{param.warnRang}");}

            if (StringUtils.isNotBlank(param.getSuspendObject())) {
                WHERE("((warn_rage=1 and child_no =#{param.suspendObject}) " +
                        "or (warn_rage=2 and order_goods_no =#{param.suspendObject}))");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            ORDER_BY("id desc");
        }}.toString();
    }

}
