package com.clx.performance.service.impl.linewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.linewarn.LineWarnConfigDao;
import com.clx.performance.enums.ResultEnum;
import com.clx.performance.enums.linewarn.LineWarnConfigEnum;
import com.clx.performance.model.linewarn.LineWarnConfig;
import com.clx.performance.param.pc.linewarn.*;
import com.clx.performance.service.linewarn.LineWarnConfigService;
import com.clx.performance.struct.linewarn.LineWarnConfigStruct;
import com.clx.performance.vo.pc.linewarn.LineWarnConfigVO;
import com.msl.common.base.Optional;
import com.msl.common.exception.ServiceSystemException;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Slf4j
@Service
public class LineWarnConfigServiceImpl implements LineWarnConfigService {

    @Autowired
    private LineWarnConfigDao lineWarnConfigDao;

    @Autowired
    private LineWarnConfigStruct lineWarnConfigStruct;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveConfig(LineWarnConfigAddParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();

        Optional<LineWarnConfig> optional = lineWarnConfigDao.findByName(param.getWarnName());
        if (optional.isPresent()){
            throw new ServiceSystemException(ResultEnum.LINE_WARN_CONFIG_EXIST);
        }

        LineWarnConfig lineWarnConfig = new LineWarnConfig();
        lineWarnConfig.setWarnName(param.getWarnName());
        lineWarnConfig.setWarnType(param.getWarnType());
        lineWarnConfig.setWarnLevel(param.getWarnLevel());

        lineWarnConfig.setInterval(param.getInterval());
        lineWarnConfig.setTimeRatio(param.getTimeRatio());
        lineWarnConfig.setTaskCompleteRatio(param.getTaskCompleteRatio());
        lineWarnConfig.setCongestionTime(param.getCongestionTime());
        lineWarnConfig.setCreateBy(loginUserInfo.getUserName());

        lineWarnConfigDao.saveEntity(lineWarnConfig);

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateConfig(LineWarnConfigUpdateParam param) {
        LineWarnConfig lineWarnConfig = lineWarnConfigDao.findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);
        if (!Objects.equals(lineWarnConfig.getWarnName(), param.getWarnName())){
            Optional<LineWarnConfig> optional = lineWarnConfigDao.findByName(param.getWarnName());
            if (optional.isPresent()){
                throw new ServiceSystemException(ResultEnum.LINE_WARN_CONFIG_EXIST);
            }
        }

        lineWarnConfig.setWarnName(param.getWarnName());
        lineWarnConfig.setWarnType(param.getWarnType());
        lineWarnConfig.setWarnLevel(param.getWarnLevel());

        lineWarnConfig.setInterval(param.getInterval());
        lineWarnConfig.setTimeRatio(param.getTimeRatio());
        lineWarnConfig.setTaskCompleteRatio(param.getTaskCompleteRatio());
        lineWarnConfig.setCongestionTime(param.getCongestionTime());
        lineWarnConfigDao.updateConfig(lineWarnConfig);
    }
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateStatus(LineWarnConfigStatusUpdateParam param) {
        LineWarnConfig lineWarnConfig = lineWarnConfigDao.findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);

        lineWarnConfig.setStatus(param.getStatus());
        lineWarnConfigDao.updateStatus(lineWarnConfig);

    }

    @Override
    public void deleteConfig(LineWarnConfigDeleteUpdateParam param) {
        LineWarnConfig lineWarnConfig = lineWarnConfigDao.findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);

        lineWarnConfig.setDeleteStatus(LineWarnConfigEnum.DeleteStatus.YES.getCode());
        lineWarnConfigDao.updateDelete(lineWarnConfig);
    }

    @Override
    public LineWarnConfigVO getConfig(Integer id) {

        return lineWarnConfigStruct.convert(lineWarnConfigDao.findById(id).orNull());
    }

    @Override
    public IPage<LineWarnConfigVO> pageConfig(PageLineWarnConfigParam param) {

        return lineWarnConfigStruct.convertPage(lineWarnConfigDao.pageByParam(param));
    }

    @Override
    public List<LineWarnConfigVO.WarnTypeItem> listWarnType() {
        List<LineWarnConfigVO.WarnTypeItem> list = new ArrayList<>();
        for (LineWarnConfigEnum.WarnType item : LineWarnConfigEnum.WarnType.values()) {
            list.add(new LineWarnConfigVO.WarnTypeItem(item.getCode(), item.getMsg()));
        }

        return list;
    }
}
