package com.clx.performance.model.customer;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * @ClassName CustomerComplaintType
 * @Description
 * @Author kavin
 * @Date 2023/12/7 10:54
 * @Version 1.0
 */

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class CustomerComplaintType implements HasKey<Integer> {
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    private String name;  //投诉类型名称
    private LocalDateTime createTime;                      //创建时间
    private LocalDateTime modifiedTime;                    //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }


}
