package com.clx.performance.mapper.vehiclewarn;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.vehiclewarn.VehicleWarnInfo;
import com.clx.performance.model.vehiclewarn.VehicleWarnRang;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnInfoParam;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnRangeParam;
import com.clx.performance.sqlProvider.vehiclewarn.VehicleWarnInfoSqlProvider;
import com.clx.performance.sqlProvider.vehiclewarn.VehicleWarnRangeSqlProvider;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

@Mapper
public interface VehicleWarnRangMapper extends BaseMapper<VehicleWarnRang> {
    String TABLE = "vehicle_warn_range";

    /**
     * @see VehicleWarnRangeSqlProvider#pageByParam(Page, PageVehicleWarnRangeParam)
     */
    @SelectProvider(type = VehicleWarnRangeSqlProvider.class, method = "pageByParam")
    IPage<VehicleWarnRang> pageByParam(@Param("page") Page page, @Param("param") PageVehicleWarnRangeParam param);

}