package com.clx.performance.encryption.oldmsl;
/**
 *  业务系统编码枚举类
 * @author xujianke
 * @date 2017年4月21日
 * @description
 */
public enum SystemCodeEnum {
	USER_SERVICE(1,"用户服务"),ORDER_SERVICE(2,"订单服务"),PAYMENT_SERVICE(3,"支付服务"),
	MESSAGE_SERVICE(4,"消息服务"),MANAGE_SERVICE(5,"管理服务"),MERCHANT_SERVICE(6,"商户服务"),
	TRADE_SERVICE(7,"交易平台服务"),AUCTION_SERVICE(8,"竞拍服务"),PERFORMANCE_SERVICE(9,"履约服务");
	// 成员变量
	private String msg;
	private int code;

	// 构造方法
	private SystemCodeEnum(int code, String msg) {
		this.msg = msg;
		this.code = code;
	}

	// 普通方法
	public static String getMsg(int code) {
		for (SystemCodeEnum c : SystemCodeEnum.values()) {
			if (c.getCode() == code) {
				return c.msg;
			}
		}
		return null;
	}
	
	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

}
