package com.clx.performance.dao.impl.linewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.linewarn.LineWarnInfoDao;
import com.clx.performance.enums.linewarn.LineWarnInfoEnum;
import com.clx.performance.mapper.linewarn.LineWarnInfoMapper;
import com.clx.performance.model.linewarn.LineWarnInfo;

import com.clx.performance.param.pc.linewarn.PageLineWarnInfoParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

@Repository
public class LineWarnInfoDaoImpl extends BaseDaoImpl<LineWarnInfoMapper, LineWarnInfo, Integer> implements LineWarnInfoDao {

    @Override
    public boolean updateStatus(LineWarnInfo item) {
        return update(lUdWrapper()
                .eq(LineWarnInfo::getId, item.getId())
                .set(LineWarnInfo::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean batchUpdateStatus(List<Integer> idList, Integer status) {
        return update(lUdWrapper()
                .in(LineWarnInfo::getId, idList)
                .set(LineWarnInfo::getStatus, status)
        );
    }

    @Override
    public boolean updateSuspendTime(LineWarnInfo item) {

        return update(lUdWrapper()
                .eq(LineWarnInfo::getWarnConfigId, item.getWarnConfigId())
                .ne(LineWarnInfo::getStatus, LineWarnInfoEnum.Status.RESOLVE.getCode())
                .set(LineWarnInfo::getSuspendTime, item.getSuspendTime())
        );

    }

    @Override
    public boolean updateWarnTime(LineWarnInfo item) {
        return update(lUdWrapper()
                .eq(LineWarnInfo::getId, item.getId())
                .set(LineWarnInfo::getWeather, item.getWeather())
                .set(LineWarnInfo::getWarnTime, item.getWarnTime())
        );
    }

    @Override
    public boolean updateByConfig(Integer warnConfigId, String warnName, Integer warnLevel) {
        return update(lUdWrapper()
                .eq(LineWarnInfo::getWarnConfigId, warnConfigId)
                .set(LineWarnInfo::getWarnName, warnName)
                .set(LineWarnInfo::getWarnLevel, warnLevel)
        );
    }

    @Override
    public Optional<LineWarnInfo> findById(Integer id) {
        return Optional.of(id)
                .map(item -> lQrWrapper()
                        .eq(LineWarnInfo::getId, id)
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public Optional<LineWarnInfo> findByOrderGoodsNoAndWarnConfigId(String orderGoodsNo, Integer warnConfigId) {
        return Optional.of(orderGoodsNo)
                .map(item -> lQrWrapper()
                        .eq(LineWarnInfo::getOrderGoodsNo, orderGoodsNo)
                        .eq(LineWarnInfo::getWarnConfigId, warnConfigId)
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public List<LineWarnInfo> listSuspendTimeout() {
        return list(lQrWrapper()
                .eq(LineWarnInfo::getStatus, LineWarnInfoEnum.Status.SUSPEND.getCode())
                .lt(LineWarnInfo::getSuspendTime, LocalDateTime.now())
        );
    }


    @Override
    public IPage<LineWarnInfo> pageByParam(PageLineWarnInfoParam param) {
        Page<LineWarnInfo> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }

}
